/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class CollectionsUtils {
    public static final <T> boolean equals(Collection<T> coll1, Collection<T> coll2) {
        if (coll1 == null) {
            return coll2 == null;
        }
        if (coll2 == null) {
            return false;
        }
        if (coll1.size() != coll2.size()) {
            return false;
        }
        Iterator<T> i = coll2.iterator();
        for (T o : coll1) {
            if (Objects.equals(o, i.next())) continue;
            return false;
        }
        return true;
    }

    public static final <K, V> boolean equals(Map<K, V> map1, Map<K, V> map2) {
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : map1.entrySet()) {
            V value = map2.get(entry.getKey());
            if (value == null) {
                return false;
            }
            if (Objects.equals(value, entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

