/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.SerializationUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Objects;

public class DatagramUtils {
    public static void send(byte[] data, int offset, int length, SocketAddress ... addresses) throws IOException {
        Objects.requireNonNull(data, "The data is null");
        Objects.requireNonNull(addresses, "No recipients: the addresses is null");
        try (DatagramSocket clientSocket = new DatagramSocket();){
            for (SocketAddress address : addresses) {
                clientSocket.send(new DatagramPacket(data, offset, length, address));
            }
        }
    }

    public static void send(byte[] data, int offset, int length, Collection<SocketAddress> addresses) throws IOException {
        Objects.requireNonNull(data, "Nothing to send: the data is null");
        Objects.requireNonNull(addresses, "No recipients: the addresses is null");
        try (DatagramSocket clientSocket = new DatagramSocket();){
            for (SocketAddress address : addresses) {
                clientSocket.send(new DatagramPacket(data, offset, length, address));
            }
        }
    }

    public static void send(byte[] data, SocketAddress ... addresses) throws IOException {
        Objects.requireNonNull(data, "Nothing to send: the data is null");
        DatagramUtils.send(data, 0, data.length, addresses);
    }

    public static void send(byte[] data, Collection<SocketAddress> addresses) throws IOException {
        Objects.requireNonNull(data, "Nothing to send: the data is null");
        DatagramUtils.send(data, 0, data.length, addresses);
    }

    public static void send(Serializable object, Collection<SocketAddress> addresses) throws IOException {
        Objects.requireNonNull(object, "Nothing to send: the object is null.");
        DatagramUtils.send(SerializationUtils.toDefaultCompressedBytes(object), addresses);
    }

    public static void send(Serializable object, SocketAddress ... addresses) throws IOException {
        Objects.requireNonNull(object, "Nothing to send: the object is null.");
        DatagramUtils.send(SerializationUtils.toDefaultCompressedBytes(object), addresses);
    }
}

