/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher
implements Runnable,
Closeable,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryWatcher.class);
    private final Path rootPath;
    private final WatchService watcher;
    private final HashSet<Consumer<Path>> consumers;
    private volatile Consumer<Path>[] consumersCache;
    private final HashMap<WatchKey, Path> keys;
    private static final HashMap<Path, DirectoryWatcher> watchers = new HashMap();

    private DirectoryWatcher(Path rootPath) throws IOException {
        FileSystem fs = FileSystems.getDefault();
        this.watcher = fs.newWatchService();
        this.rootPath = rootPath;
        this.keys = new HashMap();
        this.consumers = new HashSet();
        this.consumersCache = new Consumer[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectoryWatcher register(Path rootPath, Consumer<Path> consumer) throws IOException {
        HashMap<Path, DirectoryWatcher> hashMap = watchers;
        synchronized (hashMap) {
            DirectoryWatcher watcher = watchers.get(rootPath);
            if (watcher == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("New directory watcher: " + rootPath);
                }
                watcher = new DirectoryWatcher(rootPath);
                watchers.put(rootPath, watcher);
            }
            watcher.register(consumer);
            return watcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void register(Consumer<Path> consumer) {
        HashSet<Consumer<Path>> hashSet = this.consumers;
        synchronized (hashSet) {
            if (this.consumers.add(consumer)) {
                this.consumersCache = this.consumers.toArray(new Consumer[this.consumers.size()]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(Consumer<Path> consumer) throws IOException {
        HashSet<Consumer<Path>> hashSet = this.consumers;
        synchronized (hashSet) {
            if (this.consumers.remove(consumer)) {
                this.consumersCache = this.consumers.toArray(new Consumer[this.consumers.size()]);
            }
            HashMap<Path, DirectoryWatcher> hashMap = watchers;
            synchronized (hashMap) {
                if (this.consumersCache.length == 0) {
                    watchers.remove(this.rootPath);
                    this.close();
                }
            }
        }
    }

    public static void registerDirectory(Path rootPath, final WatchService watcher, final HashMap<WatchKey, Path> keys) throws IOException {
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public final FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                if (attrs.isDirectory()) {
                    keys.put(file.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY), file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public void run() {
        block8: {
            try {
                DirectoryWatcher.registerDirectory(this.rootPath, this.watcher, this.keys);
                while (true) {
                    WatchKey key;
                    Path dir;
                    if ((dir = this.keys.get(key = this.watcher.take())) != null) {
                        for (WatchEvent<?> watchEvent : key.pollEvents()) {
                            Path file;
                            WatchEvent.Kind<?> kind = watchEvent.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                            Object o = watchEvent.context();
                            Path path = file = o instanceof Path ? (Path)o : null;
                            if (file == null) continue;
                            Path child = dir.resolve(file);
                            if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS) || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                            DirectoryWatcher.registerDirectory(child, this.watcher, this.keys);
                        }
                        for (Consumer<Path> consumer : this.consumersCache) {
                            consumer.accept(dir.toAbsolutePath());
                        }
                    }
                    if (key.reset()) continue;
                    this.keys.remove(key);
                    if (this.keys.isEmpty()) break;
                }
            }
            catch (ClosedWatchServiceException e1) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Directory watcher ends: " + this.rootPath, e1);
                }
            }
            catch (IOException | InterruptedException e2) {
                if (!LOGGER.isWarnEnabled()) break block8;
                LOGGER.warn("Directory watcher ends: " + this.rootPath, e2);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.watcher != null) {
            this.watcher.close();
        }
    }
}

