/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.util.Iterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtils {
    public static Node getAttribute(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        return attributes == null ? null : attributes.getNamedItem(attributeName);
    }

    public static String getAttributeString(Node node, String attributeName) {
        Node attrNode = DomUtils.getAttribute(node, attributeName);
        return attrNode == null ? null : attrNode.getTextContent();
    }

    private static final void extractText(Node parent, StringBuilder sb) {
        switch (parent.getNodeType()) {
            case 3: 
            case 4: {
                sb.append(parent.getNodeValue());
            }
        }
        NodeList childrens = parent.getChildNodes();
        int l = childrens.getLength();
        for (int i = 0; i < l; ++i) {
            DomUtils.extractText(childrens.item(i), sb);
        }
    }

    public static final String getText(Node node) {
        StringBuilder sb = new StringBuilder();
        DomUtils.extractText(node, sb);
        return sb.toString();
    }

    public static Looper iterator(NodeList nodeList) {
        return new Looper(nodeList);
    }

    public static class Looper
    implements Iterator<Node>,
    Iterable<Node> {
        private final NodeList nodeList;
        private final int length;
        private int pos;

        public Looper(NodeList nodeList) {
            this.nodeList = nodeList;
            this.length = nodeList == null ? 0 : nodeList.getLength();
            this.pos = 0;
        }

        private Looper(Looper it) {
            this.nodeList = it.nodeList;
            this.length = it.length;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.length;
        }

        @Override
        public Node next() {
            return this.nodeList.item(this.pos++);
        }

        @Override
        public Iterator<Node> iterator() {
            return this.pos == 0 ? this : new Looper(this);
        }
    }
}

