/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.IOUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class ExceptionUtils
extends org.apache.commons.lang3.exception.ExceptionUtils {
    public static String getLocation(StackTraceElement[] stackTrace, String prefix) {
        for (StackTraceElement element : stackTrace) {
            if (!element.getClassName().startsWith(prefix)) continue;
            return element.toString();
        }
        return null;
    }

    public static String getFirstLocation(StackTraceElement[] stackTrace) {
        for (StackTraceElement element : stackTrace) {
            String ele = element.toString();
            if (ele == null || ele.length() <= 0) continue;
            return ele;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFullStackTrace(StackTraceElement[] stackTrace) {
        String string;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            for (StackTraceElement element : stackTrace) {
                pw.println(element);
            }
            string = sw.toString();
        }
        catch (Throwable throwable) {
            IOUtils.close(pw, sw);
            throw throwable;
        }
        IOUtils.close(pw, sw);
        return string;
    }

    public static <T extends Exception> T throwException(Exception exception, Class<T> exceptionClass) throws T {
        if (exception == null) {
            return null;
        }
        if (exceptionClass.isInstance(exception)) {
            throw exception;
        }
        try {
            return (T)((Exception)exceptionClass.getConstructor(Exception.class).newInstance(exception));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Exception getCauseIfException(Exception e) {
        if (e == null) {
            return null;
        }
        Throwable cause = e.getCause();
        return cause instanceof Exception ? (Exception)cause : e;
    }

    public static List<String> getStackTraces(Throwable throwable) {
        StackTraceElement[] stElements = throwable.getStackTrace();
        if (stElements == null) {
            return null;
        }
        ArrayList<String> stList = new ArrayList<String>(stElements.length);
        for (StackTraceElement stElement : stElements) {
            stList.add(stElement.toString());
        }
        return stList;
    }

    public static class Holder {
        private final Logger logger;
        private volatile Exception holdException;

        public Holder(Logger logger2) {
            this.logger = logger2;
            this.holdException = null;
        }

        public void switchAndWarn(Exception newException) {
            if (this.holdException != null && this.logger != null && this.logger.isWarnEnabled()) {
                this.logger.warn(this.holdException.getMessage(), this.holdException);
            }
            this.holdException = newException;
        }

        public <E extends Exception> E getException() {
            return (E)this.holdException;
        }

        public <E extends Exception> void thrownIfAny() throws E {
            if (this.holdException != null) {
                throw this.holdException;
            }
        }
    }
}

