/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.nio.ByteBuffer;
import java.nio.charset.CoderResult;

public class FastUTF8Encoder {
    private int character;
    private boolean isPair;
    private CoderResult error;
    private int lastSp;
    private int lastDp;
    public static final int MaxBytesPerChar = 4;

    public FastUTF8Encoder() {
        this.reset();
    }

    public final void reset() {
        this.error = CoderResult.UNDERFLOW;
    }

    public final CoderResult getError() {
        return this.error;
    }

    private final int parse(char c, char[] ia, int ip, int il) {
        assert (ia[ip] == c);
        if (Character.isHighSurrogate(c)) {
            if (il - ip < 2) {
                this.error = CoderResult.UNDERFLOW;
                return -1;
            }
            char d = ia[ip + 1];
            if (Character.isLowSurrogate(d)) {
                this.character = Character.toCodePoint(c, d);
                this.isPair = true;
                this.error = null;
                return this.character;
            }
            this.error = CoderResult.malformedForLength(1);
            return -1;
        }
        if (Character.isLowSurrogate(c)) {
            this.error = CoderResult.malformedForLength(1);
            return -1;
        }
        this.character = c;
        this.isPair = false;
        this.error = null;
        return this.character;
    }

    private final CoderResult encode(char[] sa, int sp, int sl, byte[] da, int dp, int dl) {
        this.lastSp = sp;
        int dlASCII = dp + Math.min(sl - this.lastSp, dl - dp);
        while (dp < dlASCII && sa[this.lastSp] < '\u0080') {
            da[dp++] = (byte)sa[this.lastSp++];
        }
        while (this.lastSp < sl) {
            char c = sa[this.lastSp];
            if (c < '\u0080') {
                da[dp++] = (byte)c;
            } else if (c < '\u0800') {
                da[dp++] = (byte)(0xC0 | c >> 6);
                da[dp++] = (byte)(0x80 | c & 0x3F);
            } else if ('\ud800' <= c && c <= '\udfff') {
                int uc = this.parse(c, sa, this.lastSp, sl);
                if (uc < 0) {
                    this.lastDp = dp;
                    return this.error;
                }
                da[dp++] = (byte)(0xF0 | uc >> 18);
                da[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                da[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                da[dp++] = (byte)(0x80 | uc & 0x3F);
                ++this.lastSp;
            } else {
                da[dp++] = (byte)(0xE0 | c >> 12);
                da[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
                da[dp++] = (byte)(0x80 | c & 0x3F);
            }
            ++this.lastSp;
        }
        this.lastDp = dp;
        return CoderResult.UNDERFLOW;
    }

    public final CoderResult encode(char[] charArray, int charLength, ByteBuffer byteBuffer) {
        CoderResult res = this.encode(charArray, 0, charLength, byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        byteBuffer.position(this.lastDp);
        return res;
    }
}

