/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.SerializationUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldMapWrapper<T> {
    protected final Map<String, Field> fieldMap;
    protected final Class<T> objectClass;

    public FieldMapWrapper(Map<String, Field> fieldMap, Class<T> objectClass) {
        this.fieldMap = fieldMap;
        this.objectClass = objectClass;
    }

    protected Map<String, Object> newMap(T row) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.fieldMap.forEach((name, field) -> {
            try {
                Object value = field.get(row);
                if (value == null) {
                    return;
                }
                if (value instanceof Number || value instanceof String) {
                    map.put((String)name, value);
                    return;
                }
                if (value instanceof Collection) {
                    map.put((String)name, value);
                    return;
                }
                if (value instanceof Map) {
                    map.put((String)name, value);
                    return;
                }
                if (value.getClass().isArray()) {
                    map.put((String)name, value);
                    return;
                }
                if (value instanceof Serializable) {
                    map.put((String)name, SerializationUtils.toExternalizorBytes((Serializable)value));
                    return;
                }
            }
            catch (IOException | ReflectiveOperationException e) {
                throw new IllegalArgumentException("Cannot convert the field " + name, e);
            }
        });
        return map.isEmpty() ? null : map;
    }

    protected List<Map<String, Object>> newMapCollection(Collection<T> rows) {
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rows.size());
        rows.forEach(row -> list.add(this.newMap(row)));
        return list;
    }

    protected List<Map<String, Object>> newMapArray(T ... rows) {
        if (rows == null || rows.length == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rows.length);
        for (T row : rows) {
            list.add(this.newMap(row));
        }
        return list;
    }

    protected T toRecord(Map<String, Object> fields) throws ReflectiveOperationException {
        if (fields == null) {
            return null;
        }
        T record = this.objectClass.newInstance();
        fields.forEach((fieldName, fieldValue) -> {
            Field field = this.fieldMap.get(fieldName);
            if (field == null || fieldValue == null) {
                return;
            }
            Class<?> fieldType = field.getType();
            Class<?> fieldValueType = fieldValue.getClass();
            try {
                if (fieldType.isAssignableFrom(fieldValueType)) {
                    field.set(record, fieldValue);
                    return;
                }
                if (fieldValue instanceof Number) {
                    Number finalValueNumber = (Number)fieldValue;
                    if (fieldType.isAssignableFrom(Long.class)) {
                        field.set(record, finalValueNumber.longValue());
                    } else if (fieldType.isAssignableFrom(Integer.class)) {
                        field.set(record, finalValueNumber.intValue());
                    } else if (fieldType.isAssignableFrom(Float.class)) {
                        field.set(record, Float.valueOf(finalValueNumber.floatValue()));
                    } else if (fieldType.isAssignableFrom(Double.class)) {
                        field.set(record, finalValueNumber.doubleValue());
                    }
                    return;
                }
                if (fieldValue instanceof Collection) {
                    Collection fieldValues = (Collection)fieldValue;
                    if (fieldValues.isEmpty()) {
                        return;
                    }
                    field.set(record, fieldValues.iterator().next());
                    return;
                }
                if (fieldValueType.isArray()) {
                    int length = Array.getLength(fieldValue);
                    if (length == 0) {
                        return;
                    }
                    if (Collection.class.isAssignableFrom(fieldType)) {
                        Collection fieldValues = (Collection)fieldType.newInstance();
                        for (int i = 0; i < length; ++i) {
                            fieldValues.add(Array.get(fieldValue, i));
                        }
                        field.set(record, fieldValues);
                    } else {
                        field.set(record, Array.get(fieldValue, 0));
                    }
                    return;
                }
                if (Serializable.class.isAssignableFrom(fieldType)) {
                    field.set(record, SerializationUtils.fromExternalizorBytes(Base64.getDecoder().decode((String)fieldValue), fieldType));
                    return;
                }
                throw new UnsupportedOperationException("Field " + fieldName + " not assignable: " + fieldType + " -> " + fieldValueType);
            }
            catch (IOException | ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        });
        return record;
    }

    protected List<T> toRecords(Collection<Map<String, Object>> docs) {
        if (docs == null) {
            return null;
        }
        ArrayList records = new ArrayList();
        docs.forEach(doc -> {
            try {
                records.add(this.toRecord((Map<String, Object>)doc));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
        return records;
    }

    protected List<T> toRecords(Map<String, Object> ... docs) {
        if (docs == null) {
            return null;
        }
        ArrayList<T> records = new ArrayList<T>();
        for (Map<String, Object> doc : docs) {
            try {
                records.add(this.toRecord(doc));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return records;
    }
}

