/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.qwazr.utils.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;

public class HashUtils {
    private static TimeBasedGenerator uuidGenerator = Generators.timeBasedGenerator(EthernetAddress.fromInterface());

    public static final int getMurmur3Mod(String hashString, Charset charset, int mod) {
        HashFunction m3 = Hashing.murmur3_128();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return Math.abs(m3.hashString(hashString, charset).asInt()) % mod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5Hex(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            String string;
            BufferedInputStream bis = new BufferedInputStream(fis);
            try {
                string = DigestUtils.md5Hex(bis);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
            IOUtils.closeQuietly(bis);
            return string;
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }

    public static String md5Hex(String text) {
        return DigestUtils.md5Hex(text);
    }

    public static UUID newTimeBasedUUID() {
        return uuidGenerator.generate();
    }
}

