/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils
extends org.apache.commons.io.IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static final void close(AutoCloseable autoCloseable) {
        block3: {
            if (autoCloseable == null) {
                return;
            }
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Close failure on " + autoCloseable, e);
            }
        }
    }

    public static final void close(AutoCloseable ... autoCloseables) {
        if (autoCloseables == null) {
            return;
        }
        for (AutoCloseable autoCloseable : autoCloseables) {
            IOUtils.close(autoCloseable);
        }
    }

    public static final void close(Collection<? extends AutoCloseable> autoCloseables) {
        if (autoCloseables == null) {
            return;
        }
        for (AutoCloseable autoCloseable : autoCloseables) {
            IOUtils.close(autoCloseable);
        }
    }

    public static final void closeObjects(Collection<?> objects) {
        if (objects == null) {
            return;
        }
        objects.forEach(object -> {
            if (object instanceof Closeable) {
                IOUtils.close((AutoCloseable)((Closeable)object));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copy(InputStream inputStream, File destFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            int n;
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                n = IOUtils.copy(inputStream, (OutputStream)fos);
            }
            catch (Throwable throwable) {
                IOUtils.close((AutoCloseable)bos);
                throw throwable;
            }
            IOUtils.close((AutoCloseable)bos);
            return n;
        }
        finally {
            IOUtils.close((AutoCloseable)fos);
        }
    }

    public static final StringBuilder copy(InputStream inputStream, StringBuilder sb, String charsetName, boolean bCloseInputStream) throws IOException {
        int length;
        if (inputStream == null) {
            return sb;
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        Charset charset = Charset.forName(charsetName);
        byte[] buffer = new byte[16384];
        while ((length = inputStream.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, length, charset));
        }
        if (bCloseInputStream) {
            inputStream.close();
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void appendLines(File file, String ... lines) throws IOException {
        FileWriter fw = null;
        PrintWriter pw = null;
        try {
            fw = new FileWriter(file, true);
            pw = new PrintWriter(fw);
            for (String line : lines) {
                pw.println(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(fw, pw);
            throw throwable;
        }
        IOUtils.close(fw, pw);
    }

    public static String readFileAsString(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            String string = IOUtils.toString(reader);
            return string;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public static void writeStringAsFile(String content, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(content);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    public static class CloseableList
    implements CloseableContext {
        private final LinkedHashSet<AutoCloseable> autoCloseables = new LinkedHashSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T extends AutoCloseable> T add(T autoCloseable) {
            LinkedHashSet<AutoCloseable> linkedHashSet = this.autoCloseables;
            synchronized (linkedHashSet) {
                this.autoCloseables.add(autoCloseable);
                return autoCloseable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(AutoCloseable autoCloseable) {
            IOUtils.close(autoCloseable);
            LinkedHashSet<AutoCloseable> linkedHashSet = this.autoCloseables;
            synchronized (linkedHashSet) {
                this.autoCloseables.remove(autoCloseable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            LinkedHashSet<AutoCloseable> linkedHashSet = this.autoCloseables;
            synchronized (linkedHashSet) {
                IOUtils.close(this.autoCloseables);
                this.autoCloseables.clear();
            }
        }
    }

    public static interface CloseableContext
    extends Closeable {
        public <T extends AutoCloseable> T add(T var1);

        public void close(AutoCloseable var1);
    }
}

