/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class Language {
    private static final String[] LANG_LIST = new String[]{"af", "ar", "bg", "bn", "cs", "da", "de", "el", "en", "es", "et", "fa", "fi", "fr", "gu", "he", "hi", "hr", "hu", "id", "it", "ja", "kn", "ko", "lt", "lv", "mk", "ml", "mr", "ne", "nl", "no", "pa", "pl", "pt", "ro", "ru", "sk", "sl", "so", "sq", "sv", "sw", "ta", "te", "th", "tl", "tr", "uk", "ur", "vi", "zh-cn", "zh-tw"};

    public static final String detect(String text, int length) throws LangDetectException {
        if (StringUtils.isEmpty(text)) {
            return null;
        }
        Detector detector = DetectorFactory.create();
        detector.setMaxTextLength(length);
        detector.append(text);
        return detector.detect();
    }

    public static final String quietDetect(String text, int length) {
        try {
            return Language.detect(text, length);
        }
        catch (LangDetectException e) {
            return null;
        }
    }

    static {
        try {
            List<String> langList = DetectorFactory.getLangList();
            ArrayList<String> profiles = new ArrayList<String>(langList.size());
            for (String lang : LANG_LIST) {
                InputStream is = Detector.class.getResourceAsStream("/profiles/" + lang);
                profiles.add(IOUtils.toString(is, Charset.defaultCharset()));
                is.close();
            }
            DetectorFactory.loadProfile(profiles);
        }
        catch (LangDetectException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

