/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.CharsetUtils;
import com.qwazr.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;

public class LinkUtils {
    public static final String urlHostPathWrapReduce(String url, int maxSize) {
        boolean bHandled;
        URL u;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            return url;
        }
        String path = StringUtils.fastConcat(u.getHost(), Character.valueOf('/'), u.getPath());
        String[] frags = StringUtils.split(path, '/');
        if (frags.length < 2) {
            return path;
        }
        int startPos = 1;
        int endPos = frags.length - 2;
        StringBuilder sbStart = new StringBuilder(frags[0]);
        StringBuilder sbEnd = new StringBuilder(frags[frags.length - 1]);
        int length = sbStart.length() + sbEnd.length();
        do {
            bHandled = false;
            if (startPos != -1 && startPos < endPos && frags[startPos].length() + length < maxSize) {
                sbStart.append('/');
                sbStart.append(frags[startPos++]);
                bHandled = true;
            }
            if (endPos == -1 || endPos <= startPos || frags[endPos].length() + length >= maxSize) continue;
            sbEnd.insert(0, '/');
            sbEnd.insert(0, frags[endPos--]);
            bHandled = true;
        } while (bHandled);
        return StringUtils.fastConcat(sbStart, "/\u2026/", sbEnd);
    }

    public static final String concatPath(String path1, String path2) {
        if (path2 == null) {
            return path1;
        }
        if (path1 == null) {
            return path2;
        }
        StringBuilder sb = new StringBuilder(path1);
        if (!path1.endsWith("/") && !path2.startsWith("/")) {
            sb.append('/');
        }
        sb.append(path2);
        return sb.toString();
    }

    public static final String lastPart(String path) {
        if (path == null) {
            return null;
        }
        String[] parts = StringUtils.split(path, '/');
        if (parts == null) {
            return path;
        }
        if (parts.length == 0) {
            return path;
        }
        return parts[parts.length - 1];
    }

    public static final String UTF8_URL_Encode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
    }

    public static final String UTF8_URL_QuietDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static final URI newEncodedURI(String u) throws MalformedURLException, URISyntaxException {
        URL tmpUrl = new URL(u);
        return new URI(tmpUrl.getProtocol(), tmpUrl.getUserInfo(), tmpUrl.getHost(), tmpUrl.getPort(), tmpUrl.getPath(), tmpUrl.getQuery(), tmpUrl.getRef());
    }

    public static final URL newEncodedURL(String u) throws MalformedURLException, URISyntaxException {
        return LinkUtils.newEncodedURI(u).toURL();
    }

    public static final MultivaluedMap<String, String> getQueryParameters(String queryString) {
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        MultivaluedHashMap<String, String> map = new MultivaluedHashMap<String, String>();
        List<NameValuePair> parameters = URLEncodedUtils.parse(queryString, CharsetUtils.CharsetUTF8);
        if (parameters != null) {
            parameters.forEach(pair -> map.add(pair.getName(), pair.getValue()));
        }
        return map;
    }

    public static final String[] getPathSegments(String path) {
        return path == null ? null : StringUtils.split(path, '/');
    }

    public static final URI resolveQuietly(URI uri, String href) {
        if (uri == null || href == null) {
            return null;
        }
        try {
            return URIUtils.resolve(uri, href);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

