/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class LockUtils {

    public static class InsideLockException
    extends RuntimeException {
        public final Exception exception;

        InsideLockException(Exception cause) {
            super(cause);
            this.exception = cause;
        }
    }

    public static interface ExceptionCallable<V, E extends Throwable> {
        public V call() throws E;
    }

    public static interface ExceptionRunnable<E extends Throwable> {
        public void run() throws E;
    }

    public static final class ReadWriteLock {
        private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(true);
        private final Lock r = this.rwl.readLock();
        private final Lock w = this.rwl.writeLock();

        public final <T> T read(Callable<T> call) {
            this.r.lock();
            try {
                T t = call.call();
                return t;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InsideLockException(e);
            }
            finally {
                this.r.unlock();
            }
        }

        public final <V, E extends Throwable> V readEx(ExceptionCallable<V, E> call) throws E {
            this.r.lock();
            try {
                V v = call.call();
                return v;
            }
            finally {
                this.r.unlock();
            }
        }

        public final void read(Runnable run) {
            this.r.lock();
            try {
                run.run();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InsideLockException(e);
            }
            finally {
                this.r.unlock();
            }
        }

        public final <E extends Throwable> void readEx(ExceptionRunnable<E> run) throws E {
            this.r.lock();
            try {
                run.run();
            }
            finally {
                this.r.unlock();
            }
        }

        public final <T> T write(Callable<T> call) {
            this.w.lock();
            try {
                T t = call.call();
                return t;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InsideLockException(e);
            }
            finally {
                this.w.unlock();
            }
        }

        public final <V, E extends Throwable> V writeEx(ExceptionCallable<V, E> call) throws E {
            this.w.lock();
            try {
                V v = call.call();
                return v;
            }
            finally {
                this.w.unlock();
            }
        }

        public final <E extends Throwable> void writeEx(ExceptionRunnable<E> run) throws E {
            this.w.lock();
            try {
                run.run();
            }
            finally {
                this.w.unlock();
            }
        }

        public final void write(Runnable run) {
            this.w.lock();
            try {
                run.run();
            }
            finally {
                this.w.unlock();
            }
        }

        public final <V> V readOrWrite(Callable<V> read, Callable<V> write) {
            V result = this.read(read);
            if (result != null) {
                return result;
            }
            this.w.lock();
            try {
                result = read.call();
                if (result != null) {
                    V v = result;
                    return v;
                }
                V v = write.call();
                return v;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InsideLockException(e);
            }
            finally {
                this.w.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <V, E extends Exception> V readOrWriteEx(ExceptionCallable<V, E> read, ExceptionCallable<V, E> write) throws Exception {
            V result = this.readEx(read);
            if (result != null) {
                return result;
            }
            this.w.lock();
            try {
                result = read.call();
                if (result != null) {
                    V v = result;
                    return v;
                }
                V v = write.call();
                return v;
            }
            finally {
                this.w.unlock();
            }
        }
    }
}

