/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeUtils {
    private static final Logger logger = LoggerFactory.getLogger(NativeUtils.class);
    public static final String NATIVE_OSS_LIBNAME = "oss-native-utils";
    public static final String NATIVE_OSS_MAPPED_LIBNAME = System.mapLibraryName("oss-native-utils");
    private static Boolean LOADED = null;

    public static final synchronized boolean loaded() {
        if (LOADED != null) {
            return LOADED;
        }
        try {
            NativeUtils.loadLibrary(NATIVE_OSS_LIBNAME);
            LOADED = true;
        }
        catch (Throwable t) {
            LOADED = false;
        }
        return LOADED;
    }

    public static void loadLibrary(String libraryName) throws UnsatisfiedLinkError, UnsupportedOperationException {
        try {
            System.loadLibrary(libraryName);
            logger.info("Native OSS loaded from classpath:" + libraryName);
        }
        catch (UnsatisfiedLinkError e1) {
            String libraryResourcePath = '/' + System.mapLibraryName(libraryName);
            InputStream inputStream = NativeUtils.class.getResourceAsStream(libraryResourcePath);
            if (inputStream == null) {
                throw new UnsatisfiedLinkError("Can't find " + libraryName + " in the filesystem nor in the classpath: " + e1.getMessage());
            }
            try {
                File libraryFile = File.createTempFile(libraryName, null);
                IOUtils.copy(inputStream, libraryFile);
                System.load(libraryFile.getAbsolutePath());
                logger.info("Native OSS loaded from temp file:" + libraryName);
            }
            catch (IOException e) {
                throw new Error("Failed to create temporary file for " + libraryName, e);
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }
}

