/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.RandomUtils;

public class RandomArrayIterator<T>
implements Iterator<T> {
    private final T[] objects;
    private int pos;
    private int count;

    public RandomArrayIterator(T[] objects) {
        this.objects = objects;
        if (objects != null) {
            this.pos = RandomUtils.nextInt(0, objects.length);
            this.count = objects.length;
        } else {
            this.pos = 0;
            this.count = 0;
        }
    }

    @Override
    public boolean hasNext() {
        return this.count > 0;
    }

    @Override
    public T next() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        T object = this.objects[this.pos++];
        if (this.pos == this.objects.length) {
            this.pos = 0;
        }
        --this.count;
        return object;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not available");
    }
}

