/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ReadOnlyMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> map = Collections.emptyMap();

    protected ReadOnlyMap() {
    }

    protected Map<K, V> setMap(Map<K, V> newMap) {
        Map<K, V> oldMap = this.map;
        this.map = newMap;
        return oldMap;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("Cannot modify a read only map");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Cannot modify a read only map");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Cannot modify a read only map");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot modify an immutable map");
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }
}

