/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import org.apache.commons.io.FileUtils;

public class RuntimeUtils {
    public static Thread mainThread = Thread.currentThread();

    public static long getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static String getMemoryUsagePretty() {
        return FileUtils.byteCountToDisplaySize(RuntimeUtils.getMemoryUsage());
    }

    public static Long getOpenFileCount() {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        if (os instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount();
        }
        return null;
    }

    public static Integer getActiveThreadCount() {
        ThreadGroup threadGroup = mainThread.getThreadGroup();
        if (threadGroup == null) {
            threadGroup = Thread.currentThread().getThreadGroup();
        }
        return threadGroup == null ? null : Integer.valueOf(threadGroup.activeCount());
    }
}

