/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.io.Reader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class ScriptUtils {
    public static void evalScript(ScriptEngine scriptEngine, AccessControlContext controlContext, Reader reader, Bindings bindings) throws ScriptException, PrivilegedActionException {
        AccessController.doPrivileged(() -> {
            scriptEngine.eval(reader, bindings);
            return null;
        }, controlContext);
    }

    public static <T> Map<String, T> toMap(ScriptObjectMirror som, Class<T> type) throws ScriptException {
        if (som == null) {
            return null;
        }
        if (som.isArray()) {
            throw new ScriptException("The JS object is an array");
        }
        LinkedHashMap map = new LinkedHashMap();
        if (som.isEmpty()) {
            return map;
        }
        som.forEach((s, o) -> map.put(s, ((ScriptObjectMirror)o).to(type)));
        return map;
    }

    public static <T> T[] toArray(ScriptObjectMirror som, Class<T> type) throws ScriptException {
        if (som == null) {
            return null;
        }
        if (!som.isArray()) {
            throw new ScriptException("The JS object is not an array");
        }
        Object[] array = new Object[som.size()];
        AtomicInteger i = new AtomicInteger(0);
        som.values().forEach(o -> {
            array[i.getAndIncrement()] = ((ScriptObjectMirror)o).to(type);
        });
        return array;
    }

    public static void fillStringCollection(ScriptObjectMirror som, Collection<String> collection) throws ScriptException {
        if (som == null) {
            return;
        }
        if (!som.isArray()) {
            throw new ScriptException("The JS object is not an array");
        }
        som.values().forEach(o -> collection.add(o.toString()));
    }

    public static void fillStringMap(ScriptObjectMirror som, Map<String, String> map) throws ScriptException {
        if (som == null) {
            return;
        }
        som.forEach((s, o) -> map.put((String)s, o.toString()));
    }

    public static class RestrictedAccessControlContext {
        public static final AccessControlContext INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
    }
}

