/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.ArrayUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final String replaceConsecutiveSpaces(String source, String replace) {
        if (StringUtils.isEmpty(source)) {
            return source;
        }
        StringBuilder target = new StringBuilder();
        int l = source.length();
        boolean consecutiveSpace = false;
        for (int i = 0; i < l; ++i) {
            char c = source.charAt(i);
            if (Character.isWhitespace(c)) {
                if (consecutiveSpace) continue;
                if (replace != null) {
                    target.append(replace);
                }
                consecutiveSpace = true;
                continue;
            }
            target.append(c);
            if (!consecutiveSpace) continue;
            consecutiveSpace = false;
        }
        return target.toString();
    }

    public static Pattern wildcardPattern(String s) {
        CharSequence[] esc = new CharSequence[]{"\\", ".", "(", ")", "[", "]", "+", "?", "*"};
        CharSequence[] replace = new CharSequence[]{"/", "\\.", "\\(", "\\)", "\\[", "\\]", "\\+", "\\?", ".*"};
        s = s.trim();
        int i = 0;
        for (CharSequence ch : esc) {
            s = s.replace(ch, replace[i++]);
        }
        return Pattern.compile(s);
    }

    public static String base64encode(String text) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty(text)) {
            return null;
        }
        return Base64.encodeBase64URLSafeString(text.getBytes("UTF-8"));
    }

    public static String base64decode(String base64String) {
        if (StringUtils.isEmpty(base64String)) {
            return null;
        }
        return new String(Base64.decodeBase64(base64String));
    }

    public static int compareNullValues(Object v1, Object v2) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return 0;
    }

    public static int compareNullString(String v1, String v2) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return v1.compareTo(v2);
    }

    public static int compareNullHashCode(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o2.hashCode() - o1.hashCode();
    }

    public static String leftPad(int value, int size) {
        return org.apache.commons.lang3.StringUtils.leftPad(Integer.toString(value), size, '0');
    }

    public static String leftPad(long value, int size) {
        return org.apache.commons.lang3.StringUtils.leftPad(Long.toString(value), size, '0');
    }

    public static String[] toStringArray(Collection<? extends Object> collection, boolean sort) {
        if (collection == null) {
            return null;
        }
        Object[] array = new String[collection.size()];
        int i = 0;
        for (Object object : collection) {
            array[i++] = object.toString();
        }
        if (sort) {
            Arrays.sort(array);
        }
        return array;
    }

    public static CharSequence fastConcatCharSequence(CharSequence ... charSeqs) {
        if (charSeqs == null) {
            return null;
        }
        if (charSeqs.length == 1) {
            return charSeqs[0];
        }
        StringBuilder sb = new StringBuilder();
        for (CharSequence charSeq : charSeqs) {
            if (charSeq == null) continue;
            sb.append(charSeq);
        }
        return sb;
    }

    public static String fastConcat(CharSequence ... charSeqs) {
        CharSequence cs = StringUtils.fastConcatCharSequence(charSeqs);
        return cs == null ? null : cs.toString();
    }

    public static void appendArray(StringBuilder sb, Object[] array) {
        for (Object object : array) {
            StringUtils.appendObject(sb, object);
        }
    }

    public static void appendCollection(StringBuilder sb, Collection<?> collection) {
        for (Object object : collection) {
            StringUtils.appendObject(sb, object);
        }
    }

    public static void appendObject(StringBuilder sb, Object object) {
        if (object instanceof Collection) {
            StringUtils.appendCollection(sb, (Collection)object);
        } else if (object instanceof Object[]) {
            StringUtils.appendArray(sb, (Object[])object);
        } else {
            sb.append(object.toString());
        }
    }

    public static CharSequence fastConcatCharSequence(Object ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 1) {
            return objects.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            if (object == null) continue;
            StringUtils.appendObject(sb, object);
        }
        return sb;
    }

    public static String fastConcat(Object ... objects) {
        CharSequence cs = StringUtils.fastConcatCharSequence(objects);
        return cs == null ? null : cs.toString();
    }

    public static int linesCollector(String text, boolean collectEmptyLines, Collection<String> lineCollector) throws IOException {
        if (text == null) {
            return 0;
        }
        int i = 0;
        try (StringReader sr = new StringReader(text);
             BufferedReader br = new BufferedReader(sr);){
            String line;
            while ((line = br.readLine()) != null) {
                if (!collectEmptyLines && line.length() == 0) continue;
                lineCollector.add(line);
                ++i;
            }
        }
        return i;
    }

    public static String escape_chars(String source, char[] escaped_chars) {
        if (escaped_chars == null || escaped_chars.length == 0) {
            return source;
        }
        if (source == null || source.length() == 0) {
            return source;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            for (char ec : escaped_chars) {
                if (c != ec) continue;
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] splitLines(String str) {
        return StringUtils.split(str, System.lineSeparator());
    }

    public static String ensureSuffix(String str, String suffix) {
        if (suffix == null) {
            return str;
        }
        if (str == null) {
            return null;
        }
        if (str.endsWith(suffix)) {
            return str;
        }
        return str + suffix;
    }

    public static String replaceEach(String text, Map<String, Object> replacements) {
        if (replacements == null) {
            return text;
        }
        String[] search = ArrayUtils.toArray(replacements.keySet());
        String[] replace = ArrayUtils.toStringArray(replacements.values());
        return StringUtils.replaceEach(text, search, replace);
    }

    public static boolean anyDigit(CharSequence chars) {
        if (chars == null) {
            return false;
        }
        return chars.chars().anyMatch(new IntPredicate(){

            @Override
            public boolean test(int value) {
                return Character.isDigit(value);
            }
        });
    }

    public static boolean anyAlpha(CharSequence chars) {
        if (chars == null) {
            return false;
        }
        return chars.chars().anyMatch(new IntPredicate(){

            @Override
            public boolean test(int value) {
                return Character.isAlphabetic(value);
            }
        });
    }
}

