/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class SubstitutedVariables {
    private final Map<String, String> variables;
    private final String prefix;
    private final String suffix;
    private volatile SubstituteList substituteList;
    private static volatile SubstitutedVariables environmentVariables = null;
    private static volatile SubstitutedVariables propertiesVariables = null;

    public SubstitutedVariables(String prefix, String suffix) {
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
        this.variables = new HashMap<String, String>();
        this.updateSubstituteList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<String, String> source) {
        if (source == null) {
            return;
        }
        Map<String, String> map = this.variables;
        synchronized (map) {
            source.forEach((key, value) -> this.variables.put(this.prefix + key + this.suffix, (String)value));
            this.updateSubstituteList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Properties properties) {
        if (properties == null) {
            return;
        }
        Map<String, String> map = this.variables;
        synchronized (map) {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.variables.put(this.prefix + key + this.suffix, value == null ? "" : value.toString())));
            this.updateSubstituteList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, String> map = this.variables;
        synchronized (map) {
            this.variables.clear();
            this.updateSubstituteList();
        }
    }

    private synchronized void updateSubstituteList() {
        this.substituteList = new SubstituteList(this.variables);
    }

    public String substitute(String source) {
        if (source == null) {
            return null;
        }
        return this.substituteList.substitute(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubstitutedVariables getEnvironmentVariables() {
        if (environmentVariables != null) {
            return environmentVariables;
        }
        Class<SubstitutedVariables> clazz = SubstitutedVariables.class;
        synchronized (SubstitutedVariables.class) {
            if (environmentVariables != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return environmentVariables;
            }
            environmentVariables = new SubstitutedVariables("${", "}");
            environmentVariables.putAll(System.getenv());
            // ** MonitorExit[var0] (shouldn't be in output)
            return environmentVariables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubstitutedVariables getPropertiesVariables() {
        if (propertiesVariables != null) {
            return propertiesVariables;
        }
        Class<SubstitutedVariables> clazz = SubstitutedVariables.class;
        synchronized (SubstitutedVariables.class) {
            if (propertiesVariables != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return propertiesVariables;
            }
            propertiesVariables = new SubstitutedVariables("${", "}");
            propertiesVariables.putAll(System.getProperties());
            // ** MonitorExit[var0] (shouldn't be in output)
            return propertiesVariables;
        }
    }

    public static String propertyAndEnvironmentSubstitute(String source) {
        source = SubstitutedVariables.getPropertiesVariables().substitute(source);
        return SubstitutedVariables.getEnvironmentVariables().substitute(source);
    }

    private static class SubstituteList {
        private final String[] searchList;
        private final String[] replacementList;

        private SubstituteList(Map<String, String> variables) {
            this.searchList = new String[variables.size()];
            this.replacementList = new String[this.searchList.length];
            int i = 0;
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                this.searchList[i] = entry.getKey();
                this.replacementList[i++] = entry.getValue();
            }
        }

        public final String substitute(String source) {
            if (source == null) {
                return source;
            }
            if (source.isEmpty()) {
                return source;
            }
            if (this.searchList.length == 0) {
                return source;
            }
            return StringUtils.replaceEachRepeatedly(source, this.searchList, this.replacementList);
        }
    }
}

