/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class TimeTracker {
    private final long startTime;
    private volatile long time;
    private volatile long unknownTime = 0L;
    private final LinkedHashMap<String, Long> entries = new LinkedHashMap();
    private volatile LinkedHashMap<String, Long> cachedEntries = null;

    public TimeTracker() {
        this.startTime = this.time = System.currentTimeMillis();
    }

    public synchronized void next(String name) {
        long t = System.currentTimeMillis();
        long elapsed = t - this.time;
        if (name != null) {
            Long duration = this.entries.get(name);
            duration = duration == null ? Long.valueOf(elapsed) : Long.valueOf(duration + elapsed);
            this.entries.put(name, duration);
            this.cachedEntries = null;
        } else {
            this.unknownTime += elapsed;
        }
        this.time = t;
    }

    private synchronized LinkedHashMap<String, Long> buildCache() {
        if (this.cachedEntries == null) {
            this.cachedEntries = new LinkedHashMap<String, Long>(this.entries);
        }
        return this.cachedEntries;
    }

    public Status getStatus() {
        return new Status(this);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Status {
        public final Date start_time;
        public final Long total_time;
        public final Long unknown_time;
        public final LinkedHashMap<String, Long> durations;

        public Status() {
            this.start_time = null;
            this.total_time = null;
            this.unknown_time = null;
            this.durations = null;
        }

        private Status(TimeTracker timeTracker) {
            this.start_time = new Date(timeTracker.startTime);
            this.total_time = timeTracker.time - timeTracker.startTime;
            this.unknown_time = timeTracker.unknownTime;
            this.durations = timeTracker.buildCache();
        }

        public Date getStart_time() {
            return this.start_time;
        }

        public Long getTotal_time() {
            return this.total_time;
        }

        public Long getUnknown_time() {
            return this.unknown_time;
        }

        public Map<String, Long> getDurations() {
            return this.durations;
        }
    }
}

