/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.RegExpUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;

public class UBuilder
extends URIBuilder {
    public UBuilder() {
    }

    public UBuilder(String string) throws URISyntaxException {
        super(string);
    }

    public UBuilder(URI uri) {
        super(uri);
    }

    public final UBuilder setParameterObject(String param, Object object) {
        if (object == null) {
            return this;
        }
        super.setParameter(param, object.toString());
        return this;
    }

    @Override
    public final UBuilder setParameter(String param, String value) {
        if (value == null) {
            return this;
        }
        super.setParameter(param, value);
        return this;
    }

    public final UBuilder setParameter(String param, Enum value) {
        if (value == null) {
            return this;
        }
        super.setParameter(param, value.name());
        return this;
    }

    public final UBuilder setParameter(String param, Number value) {
        if (value == null) {
            return this;
        }
        super.setParameter(param, value.toString());
        return this;
    }

    public final UBuilder setParameters(Boolean local, String group, Integer msTimeout) {
        this.setParameterObject("local", local);
        this.setParameterObject("group", group);
        this.setParameterObject("timeout", msTimeout);
        return this;
    }

    public final URI buildNoEx() {
        try {
            return super.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public final void removeMatchingParameters(Collection<Matcher> matcherList) {
        if (matcherList == null || matcherList.isEmpty()) {
            return;
        }
        List<NameValuePair> oldParams = this.getQueryParams();
        if (oldParams == null || oldParams.isEmpty()) {
            return;
        }
        this.clearParameters();
        for (NameValuePair param : oldParams) {
            if (RegExpUtils.anyMatch(param.getName() + "=" + param.getValue(), matcherList)) continue;
            this.addParameter(param.getName(), param.getValue());
        }
    }

    public final void cleanPath(Collection<Matcher> matcherList) {
        if (matcherList == null || matcherList.isEmpty()) {
            return;
        }
        String path = this.getPath();
        if (path == null || path.isEmpty()) {
            return;
        }
        this.setPath(RegExpUtils.removeAllMatches(path, matcherList));
    }
}

