/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.io.IOCase;

public class WildcardMatcher {
    private final String[] wcs;
    private final String pattern;

    public WildcardMatcher(String pattern) {
        this.pattern = pattern;
        this.wcs = pattern == null ? null : WildcardMatcher.splitOnTokens(pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean match(String name, IOCase caseSensitivity) {
        if (name == null && this.wcs == null) {
            return true;
        }
        if (name == null || this.wcs == null) {
            return false;
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        int length = name.length();
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (backtrack.size() > 0) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < this.wcs.length) {
                if (this.wcs[wcsIdx].equals("?")) {
                    if (++textIdx > length) break;
                    anyChars = false;
                } else if (this.wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == this.wcs.length - 1) {
                        textIdx = length;
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = caseSensitivity.checkIndexOf(name, textIdx, this.wcs[wcsIdx])) == -1) break;
                        int repeat = caseSensitivity.checkIndexOf(name, textIdx + 1, this.wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!caseSensitivity.checkRegionMatches(name, textIdx, this.wcs[wcsIdx])) break;
                    textIdx += this.wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != this.wcs.length || textIdx != length) continue;
            return true;
        } while (backtrack.size() > 0);
        return false;
    }

    public boolean match(String name) {
        return this.match(name, IOCase.INSENSITIVE);
    }

    static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == '?' || array[i] == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (array[i] == '?') {
                    list.add("?");
                    continue;
                }
                if (!list.isEmpty() && (i <= 0 || ((String)list.get(list.size() - 1)).equals("*"))) continue;
                list.add("*");
                continue;
            }
            buffer.append(array[i]);
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public static final List<WildcardMatcher> getList(Collection<String> patternList) {
        if (patternList == null || patternList.isEmpty()) {
            return null;
        }
        ArrayList<WildcardMatcher> matcherList = new ArrayList<WildcardMatcher>(patternList.size());
        for (String pattern : patternList) {
            matcherList.add(new WildcardMatcher(pattern));
        }
        return matcherList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean anyMatch(String value, List<WildcardMatcher> matcherList) {
        Iterator<WildcardMatcher> iterator = matcherList.iterator();
        while (iterator.hasNext()) {
            WildcardMatcher matcher;
            WildcardMatcher wildcardMatcher = matcher = iterator.next();
            synchronized (wildcardMatcher) {
                if (matcher.match(value)) {
                    return true;
                }
            }
        }
        return false;
    }
}

