/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.google.common.util.concurrent.AtomicDouble;
import com.qwazr.utils.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;

public class WordCount {
    private final HashMap<String, AtomicInteger> wordCount = new HashMap();

    public WordCount() {
    }

    public WordCount(String sentence) {
        this();
        this.addSentence(sentence);
    }

    public WordCount(String[] sentences) {
        this();
        for (String sentence : sentences) {
            this.addSentence(sentence);
        }
    }

    public WordCount(Collection<String> sentences) {
        this();
        sentences.forEach(sentence -> this.addSentence((String)sentence));
    }

    public void addSentence(String sentence) {
        String[] words;
        if (sentence == null) {
            return;
        }
        for (String word : words = StringUtils.split(sentence, "\t \n\r")) {
            this.addWord(word);
        }
    }

    public int addWord(String word) {
        if (word == null) {
            return 0;
        }
        return this.wordCount.computeIfAbsent(word, k -> new AtomicInteger()).incrementAndGet();
    }

    public static float compare(WordCount dic1, WordCount dic2) {
        HashSet<String> wordSet = new HashSet<String>(dic1.wordCount.keySet());
        wordSet.addAll(dic2.wordCount.keySet());
        AtomicDouble similarity = new AtomicDouble();
        wordSet.forEach(word -> {
            double v2;
            AtomicInteger c1 = dic1.wordCount.get(word);
            AtomicInteger c2 = dic2.wordCount.get(word);
            if (c1 == null || c2 == null) {
                return;
            }
            double v1 = c1.doubleValue();
            double delta = v1 > (v2 = c2.doubleValue()) ? v2 / v1 : v1 / v2;
            similarity.addAndGet(delta);
        });
        return similarity.floatValue() / (float)wordSet.size();
    }
}

