/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.DomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathParser {
    private static final XPathFactory xPathfactory = XPathFactory.newInstance();
    private final XPath xPath = XPathParser.getXPath();
    private final ConcurrentHashMap<String, XPathExpression> xPathExpressions = new ConcurrentHashMap();
    private static final List<Pair<QName, BiConsumer<Object, Consumer>>> consumers = new ArrayList<Pair<QName, BiConsumer<Object, Consumer>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final XPath getXPath() {
        XPathFactory xPathFactory = xPathfactory;
        synchronized (xPathFactory) {
            return xPathfactory.newXPath();
        }
    }

    private XPathExpression getExpression(String query) {
        return this.xPathExpressions.computeIfAbsent(query, s -> {
            try {
                return this.xPath.compile(query);
            }
            catch (XPathExpressionException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    public final String evaluateString(Node rootNode, String query) throws XPathExpressionException {
        return this.getExpression(query).evaluate(rootNode);
    }

    public final Number evaluateNumber(Node rootNode, String query) throws XPathExpressionException {
        return (Number)this.getExpression(query).evaluate(rootNode, XPathConstants.NUMBER);
    }

    public final Boolean evaluateBoolean(Node rootNode, String query) throws XPathExpressionException {
        return (Boolean)this.getExpression(query).evaluate(rootNode, XPathConstants.BOOLEAN);
    }

    public final Node evaluateNode(Node rootNode, String query) throws XPathExpressionException {
        return (Node)this.getExpression(query).evaluate(rootNode, XPathConstants.NODE);
    }

    public final DomUtils.Looper evaluateNodes(Node rootNode, String query) throws XPathExpressionException {
        return DomUtils.iterator((NodeList)this.getExpression(query).evaluate(rootNode, XPathConstants.NODESET));
    }

    public final void evaluate(Node rootNode, String query, Consumer consumer) throws XPathExpressionException {
        XPathExpressionException lastError = null;
        XPathExpression expression = this.getExpression(query);
        for (Pair<QName, BiConsumer<Object, Consumer>> pair : consumers) {
            try {
                Object result = expression.evaluate(rootNode, pair.getLeft());
                if (result == null) continue;
                pair.getRight().accept(result, consumer);
                return;
            }
            catch (XPathExpressionException e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
    }

    static {
        consumers.add(Pair.of(XPathConstants.NODESET, (object, consumer) -> {
            if (object != null && consumer != null) {
                DomUtils.iterator((NodeList)object).forEach(consumer::accept);
            }
        }));
        consumers.add(Pair.of(XPathConstants.NODE, (object, consumer) -> {
            if (object != null && consumer != null) {
                consumer.accept((Node)object);
            }
        }));
        consumers.add(Pair.of(XPathConstants.STRING, (object, consumer) -> {
            if (object != null && consumer != null) {
                consumer.accept((String)object);
            }
        }));
        consumers.add(Pair.of(XPathConstants.NUMBER, (object, consumer) -> {
            if (object != null && consumer != null) {
                consumer.accept((Number)object);
            }
        }));
        consumers.add(Pair.of(XPathConstants.BOOLEAN, (object, consumer) -> {
            if (object != null && consumer != null) {
                consumer.accept((Boolean)object);
            }
        }));
    }

    public static interface Consumer {
        default public void accept(Node object) {
        }

        default public void accept(Boolean object) {
        }

        default public void accept(String object) {
        }

        default public void accept(Number object) {
        }
    }
}

