/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.concurrent;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public abstract class ConcurrentQueue<T>
implements Consumer<T>,
Closeable {
    private final ArrayBlockingQueue<T> queue;
    private final List<Future> futures = new ArrayList<Future>();
    private final T breakItem;

    protected ConcurrentQueue(ExecutorService executor, int threadNumber, T breakItem) {
        this.breakItem = breakItem;
        this.queue = new ArrayBlockingQueue(threadNumber);
        for (int i = 0; i < threadNumber; ++i) {
            this.futures.add(executor.submit(new ItemConsumer()));
        }
    }

    protected abstract Consumer<T> getNewConsumer();

    @Override
    public void close() {
        try {
            for (int i = 0; i < this.futures.size(); ++i) {
                this.queue.put(this.breakItem);
            }
            for (Future future : this.futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.futures.clear();
    }

    @Override
    public final void accept(T entry) {
        try {
            this.queue.put(entry);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private class ItemConsumer
    implements Runnable {
        private final Consumer<T> consumer;

        private ItemConsumer() {
            this.consumer = ConcurrentQueue.this.getNewConsumer();
        }

        @Override
        public final void run() {
            try {
                while (true) {
                    Object item;
                    if ((item = ConcurrentQueue.this.queue.take()) == ConcurrentQueue.this.breakItem) {
                        return;
                    }
                    this.consumer.accept(item);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

