/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.concurrent;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PeriodicThread
extends Thread {
    protected final int monitoring_period;
    private volatile Long lastExecutionTime = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicThread.class);

    protected PeriodicThread(String threadName, int monitoring_period_seconds) {
        super(threadName);
        this.monitoring_period = monitoring_period_seconds * 1000;
    }

    protected abstract void runner();

    @Override
    public void run() {
        while (true) {
            long start = System.currentTimeMillis();
            this.lastExecutionTime = start;
            this.runner();
            this.sleepMs((long)this.monitoring_period - (System.currentTimeMillis() - start));
        }
    }

    protected void sleepMs(long sleepMs) {
        block3: {
            if (sleepMs <= 0L) {
                return;
            }
            try {
                PeriodicThread.sleep(this.monitoring_period);
            }
            catch (InterruptedException e) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn(e.getMessage(), e);
            }
        }
    }

    public Date getLastExecutionDate() {
        Long time = this.lastExecutionTime;
        if (time == null) {
            return null;
        }
        return new Date(time);
    }
}

