/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.concurrent;

import com.qwazr.utils.ExceptionUtils;
import com.qwazr.utils.concurrent.ThreadUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;

public class ThreadInfo {
    private final String name;
    private final String location;
    private final Thread.State state;
    private final String fullStackTrace;

    public ThreadInfo(Thread thread, String prefix) {
        this.name = thread.getName();
        StackTraceElement[] elements = thread.getStackTrace();
        String l = ExceptionUtils.getLocation(elements, prefix);
        if (l == null) {
            l = ExceptionUtils.getFirstLocation(elements);
        }
        this.fullStackTrace = ExceptionUtils.getFullStackTrace(elements);
        this.location = l;
        this.state = thread.getState();
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public Thread.State getState() {
        return this.state;
    }

    public String getFullStackTrace() {
        return this.fullStackTrace;
    }

    public static List<ThreadInfo> getInfos(String classNamePrefix, ThreadGroup ... groups) throws NamingException {
        if (groups == null) {
            return null;
        }
        int count = 0;
        ArrayList<Thread[]> threadsArrayList = new ArrayList<Thread[]>(groups.length);
        for (ThreadGroup group : groups) {
            Thread[] threadArray = ThreadUtils.getThreadArray(group);
            threadsArrayList.add(threadArray);
            count += threadArray.length;
        }
        ArrayList<ThreadInfo> threadList = new ArrayList<ThreadInfo>(count);
        Iterator iterator = threadsArrayList.iterator();
        while (iterator.hasNext()) {
            Thread[] threadArray;
            for (Thread thread : threadArray = (Thread[])iterator.next()) {
                threadList.add(new ThreadInfo(thread, classNamePrefix));
            }
        }
        return threadList;
    }
}

