/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.concurrent;

import java.util.Collection;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;

public class ThreadUtils {
    public static Thread[] getThreadArray(ThreadGroup group) {
        int l;
        Thread[] threads = new Thread[group.activeCount()];
        while ((l = group.enumerate(threads)) != threads.length) {
            threads = new Thread[l];
        }
        return threads;
    }

    public static boolean waitUntil(long secTimeOut, WaitInterface waiter) throws InterruptedException {
        long finalTime = System.currentTimeMillis() + secTimeOut * 1000L;
        while (!waiter.done()) {
            if (waiter.abort()) {
                return false;
            }
            if (secTimeOut != 0L && System.currentTimeMillis() > finalTime) {
                return false;
            }
            Thread.sleep(200L);
        }
        return true;
    }

    public static <T> void parallel(Collection<T> collection, ParallelConsumer<T> consumer) throws Exception {
        AtomicReference exceptionRef = new AtomicReference();
        collection.parallelStream().forEach(item -> {
            try {
                consumer.accept(item);
            }
            catch (Exception e) {
                exceptionRef.compareAndSet(null, e);
            }
        });
        Exception exception = (Exception)exceptionRef.get();
        if (exception == null) {
            return;
        }
        throw (Exception)exceptionRef.get();
    }

    public static void parallel(Collection<? extends ParallelRunnable> runnables) throws Exception {
        AtomicReference exceptionRef = new AtomicReference();
        runnables.parallelStream().forEach(runnable -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                exceptionRef.compareAndSet(null, e);
            }
        });
        Exception exception = (Exception)exceptionRef.get();
        if (exception == null) {
            return;
        }
        throw (Exception)exceptionRef.get();
    }

    public static interface ParallelRunnable {
        public void run() throws Exception;
    }

    public static interface ParallelConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    public static interface WaitInterface {
        public boolean done();

        public boolean abort();
    }

    public static class ThreadGroupFactory
    implements ThreadFactory {
        private final ThreadGroup group;

        public ThreadGroupFactory(ThreadGroup group) {
            this.group = group;
        }

        @Override
        public Thread newThread(Runnable target) {
            return new Thread(this.group, target);
        }
    }
}

