/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.http;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;

public class HttpClients {
    public static final CloseableHttpClient HTTP_CLIENT;
    public static final PoolingHttpClientConnectionManager CNX_MANAGER;
    public static final CloseableHttpClient UNSECURE_HTTP_CLIENT;
    public static final PoolingHttpClientConnectionManager UNSECURE_CNX_MANAGER;

    static {
        SSLConnectionSocketFactory ssl = null;
        try {
            ssl = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException ex) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, null, null);
                ssl = new SSLConnectionSocketFactory(sslcontext);
            }
            catch (SecurityException securityException) {
            }
            catch (KeyManagementException keyManagementException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        Registry<ConnectionSocketFactory> sfr = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)(ssl != null ? ssl : SSLConnectionSocketFactory.getSocketFactory()))).build();
        CNX_MANAGER = new PoolingHttpClientConnectionManager(sfr);
        CNX_MANAGER.setDefaultMaxPerRoute(100);
        CNX_MANAGER.setMaxTotal(200);
        CNX_MANAGER.setValidateAfterInactivity(1000);
        HTTP_CLIENT = HttpClientBuilder.create().setConnectionManager(CNX_MANAGER).build();
        try {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (arg0, arg1) -> true).build();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry<ConnectionSocketFactory> sfr2 = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslSocketFactory)).build();
            UNSECURE_CNX_MANAGER = new PoolingHttpClientConnectionManager(sfr2);
            UNSECURE_CNX_MANAGER.setDefaultMaxPerRoute(100);
            UNSECURE_CNX_MANAGER.setMaxTotal(200);
            UNSECURE_CNX_MANAGER.setValidateAfterInactivity(1000);
            UNSECURE_HTTP_CLIENT = HttpClientBuilder.create().setSSLContext(sslContext).setConnectionManager(UNSECURE_CNX_MANAGER).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

