/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.http;

import com.qwazr.utils.http.HttpClients;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.AbstractHttpMessage;

public abstract class HttpRequest<T extends HttpRequestBase> {
    public final T request;

    public static final Base<HttpHead> Head(String uri) {
        return new Base<HttpHead>(new HttpHead(uri), null);
    }

    public static final Base<HttpHead> Head(URI uri) {
        return new Base<HttpHead>(new HttpHead(uri), null);
    }

    public static final Base<HttpGet> Get(String uri) {
        return new Base<HttpGet>(new HttpGet(uri), null);
    }

    public static final Base<HttpGet> Get(URI uri) {
        return new Base<HttpGet>(new HttpGet(uri), null);
    }

    public static final Base<HttpDelete> Delete(String uri) {
        return new Base<HttpDelete>(new HttpDelete(uri), null);
    }

    public static final Base<HttpDelete> Delete(URI uri) {
        return new Base<HttpDelete>(new HttpDelete(uri), null);
    }

    public static final Base<HttpTrace> Trace(String uri) {
        return new Base<HttpTrace>(new HttpTrace(uri), null);
    }

    public static final Base<HttpTrace> Trace(URI uri) {
        return new Base<HttpTrace>(new HttpTrace(uri), null);
    }

    public static final Base<HttpOptions> Options(String uri) {
        return new Base<HttpOptions>(new HttpOptions(uri), null);
    }

    public static final Base<HttpOptions> Options(URI uri) {
        return new Base<HttpOptions>(new HttpOptions(uri), null);
    }

    public static final Entity<HttpPost> Post(String uri) {
        return new Entity<HttpPost>(new HttpPost(uri), null);
    }

    public static final Entity<HttpPost> Post(URI uri) {
        return new Entity<HttpPost>(new HttpPost(uri), null);
    }

    public static final Entity<HttpPut> Put(String uri) {
        return new Entity<HttpPut>(new HttpPut(uri), null);
    }

    public static final Entity<HttpPut> Put(URI uri) {
        return new Entity<HttpPut>(new HttpPut(uri), null);
    }

    public static final Entity<HttpPatch> Patch(String uri) {
        return new Entity<HttpPatch>(new HttpPatch(uri), null);
    }

    public static final Entity<HttpPatch> Patch(URI uri) {
        return new Entity<HttpPatch>(new HttpPatch(uri), null);
    }

    private HttpRequest(T request) {
        this.request = request;
    }

    public final CloseableHttpResponse execute() throws IOException {
        return HttpClients.HTTP_CLIENT.execute((HttpUriRequest)this.request);
    }

    public final CloseableHttpResponse execute(HttpClientContext context) throws IOException {
        return HttpClients.HTTP_CLIENT.execute((HttpUriRequest)this.request, context);
    }

    public final HttpRequest<T> addHeader(Header header) {
        ((AbstractHttpMessage)this.request).addHeader(header);
        return this;
    }

    public final HttpRequest<T> addHeader(String name, String value) {
        ((AbstractHttpMessage)this.request).addHeader(name, value);
        return this;
    }

    /* synthetic */ HttpRequest(HttpRequestBase x0, 1 x1) {
        this(x0);
    }

    public static class Entity<E extends HttpEntityEnclosingRequestBase>
    extends Base<E> {
        private Entity(E request) {
            super((HttpRequestBase)request, null);
        }

        public final Entity<E> bodyString(String content, ContentType type) {
            ((HttpEntityEnclosingRequestBase)this.request).setEntity(new StringEntity(content, type));
            return this;
        }

        public final Entity<E> bodyStream(InputStream stream, ContentType type) {
            ((HttpEntityEnclosingRequestBase)this.request).setEntity(new InputStreamEntity(stream, type));
            return this;
        }

        /* synthetic */ Entity(HttpEntityEnclosingRequestBase x0, 1 x1) {
            this(x0);
        }
    }

    public static class Base<B extends HttpRequestBase>
    extends HttpRequest<B> {
        private Base(B request) {
            super((HttpRequestBase)request, null);
        }

        /* synthetic */ Base(HttpRequestBase x0, 1 x1) {
            this(x0);
        }
    }
}

