/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.http;

import com.qwazr.utils.CharsetUtils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.util.EntityUtils;

public class HttpResponseEntityException
extends HttpResponseException {
    private static final long serialVersionUID = 1958648159987063347L;

    public HttpResponseEntityException(StatusLine statusLine, HttpEntity entity, String message) {
        super(HttpResponseEntityException.getStatusCode(statusLine), HttpResponseEntityException.getMessage(entity, message));
    }

    private static int getStatusCode(StatusLine statusLine) {
        if (statusLine == null) {
            return 0;
        }
        return statusLine.getStatusCode();
    }

    private static String getMessage(HttpEntity entity, String message) {
        try {
            if (entity != null) {
                return EntityUtils.toString(entity, CharsetUtils.CharsetUTF8);
            }
            return message;
        }
        catch (IOException e) {
            return message;
        }
    }

    public static HttpResponseEntityException findFirstCause(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof HttpResponseEntityException) {
            return (HttpResponseEntityException)e;
        }
        return HttpResponseEntityException.findFirstCause(e.getCause());
    }
}

