/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.http;

import com.qwazr.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class HttpUtils {
    public static Map<String, String> getHeaderParameters(String headerContent) {
        if (headerContent == null) {
            return null;
        }
        String[] params = StringUtils.split(headerContent, ';');
        if (params == null || params.length == 0) {
            return null;
        }
        LinkedHashMap<String, String> nameValues = new LinkedHashMap<String, String>();
        for (String param : params) {
            String[] nameValue;
            if (param == null || (nameValue = StringUtils.split(param, "=")) == null || nameValue.length != 2) continue;
            String value = nameValue[1].trim();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            nameValues.put(nameValue[0].trim().toLowerCase(), value);
        }
        return nameValues;
    }

    public static String getHeaderParameter(String headerContent, String paramName) {
        if (headerContent == null) {
            return null;
        }
        Map<String, String> headerParams = HttpUtils.getHeaderParameters(headerContent);
        if (headerParams == null) {
            return null;
        }
        return headerParams.get(paramName.trim().toLowerCase());
    }
}

