/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.inputstream;

import com.qwazr.utils.inputstream.SizeExceededException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CountingInputStream;

public final class LimiterInputStream
extends CountingInputStream {
    private final long sizeLimit;

    public LimiterInputStream(InputStream input, long sizeLimit) {
        super(input);
        this.sizeLimit = sizeLimit;
    }

    @Override
    public final int read() throws IOException {
        int c = super.read();
        if (c == -1) {
            return -1;
        }
        this.checkSizeLimit();
        return c;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        int c = super.read(b, off, len);
        switch (c) {
            case -1: {
                return -1;
            }
            case 0: {
                return 0;
            }
        }
        this.checkSizeLimit();
        return c;
    }

    @Override
    public final long skip(long n) throws IOException {
        long c = super.skip(n);
        this.checkSizeLimit();
        return c;
    }

    private void checkSizeLimit() throws IOException {
        long count = this.getByteCount();
        if (count > this.sizeLimit) {
            throw new SizeExceededException(count, this.sizeLimit);
        }
    }
}

