/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.jdbc;

import com.qwazr.utils.jdbc.Row;
import com.qwazr.utils.jdbc.RowIterator;
import com.qwazr.utils.jdbc.connection.ConnectionManager;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Query {
    private ResultSet resultSet;
    private HashMap<Class<?>, List<?>> resultListMap;
    private PreparedStatement statement;
    private int firstResult;
    private int maxResults;
    protected static final Logger logger = Logger.getLogger(Query.class.getCanonicalName());

    protected Query(PreparedStatement statement) {
        this.statement = statement;
        this.firstResult = 0;
        this.maxResults = -1;
        this.resultListMap = new HashMap();
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    protected void closeAll() {
        ConnectionManager.close(this.resultSet, this.statement, null);
    }

    private <T> List<T> createBeanList(Class<T> beanClass) throws Exception {
        ResultSetMetaData rs = this.resultSet.getMetaData();
        int columnCount = rs.getColumnCount();
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        ArrayList<MethodColumnIndex> methods = new ArrayList<MethodColumnIndex>();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Search properties for bean " + beanClass.getSimpleName());
        }
        block0: for (int i = 1; i <= columnCount; ++i) {
            String columnName = rs.getColumnLabel(i);
            for (PropertyDescriptor propDesc : props) {
                if (propDesc.getWriteMethod() == null || !propDesc.getName().equalsIgnoreCase(columnName)) continue;
                methods.add(new MethodColumnIndex(i, propDesc.getWriteMethod()));
                if (!logger.isLoggable(Level.FINEST)) continue block0;
                logger.finest("Found property \"" + propDesc.getName() + "\" for column name \"" + columnName + "\"");
                continue block0;
            }
        }
        ArrayList<Object> list = new ArrayList<Object>();
        this.moveToFirstResult();
        int limit = this.maxResults;
        while (this.resultSet.next() && limit-- != 0) {
            Object bean = Beans.instantiate(beanClass.getClassLoader(), beanClass.getCanonicalName());
            for (MethodColumnIndex methodColumnIndex : methods) {
                methodColumnIndex.invoke(bean, this.resultSet);
            }
            list.add(bean);
        }
        return list;
    }

    private void moveToFirstResult() throws SQLException {
        if (this.firstResult == 0) {
            return;
        }
        switch (this.statement.getResultSetType()) {
            case 1003: {
                int i = this.firstResult;
                while (i-- > 0) {
                    this.resultSet.next();
                }
                break;
            }
            default: {
                this.resultSet.absolute(this.firstResult);
            }
        }
    }

    private static LinkedHashMap<String, Integer> buildColumnMap(ResultSet resultSet) throws SQLException {
        LinkedHashMap<String, Integer> columnMap = new LinkedHashMap<String, Integer>();
        if (resultSet == null) {
            return columnMap;
        }
        ResultSetMetaData rs = resultSet.getMetaData();
        if (rs == null) {
            return columnMap;
        }
        int columnCount = rs.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            columnMap.put(rs.getColumnLabel(i + 1), i);
        }
        return columnMap;
    }

    private static List<Row> createRowList(ResultSet resultSet, int limit) throws SQLException {
        LinkedHashMap<String, Integer> columnMap = Query.buildColumnMap(resultSet);
        ArrayList<Row> rows = new ArrayList<Row>();
        while (resultSet.next() && limit-- != 0) {
            rows.add(new Row(columnMap, resultSet));
        }
        return rows;
    }

    private List<Row> createRowList(int limit) throws SQLException {
        this.moveToFirstResult();
        List<Row> rows = Query.createRowList(this.resultSet, limit);
        return rows;
    }

    public Iterator<Row> getRowIterator() {
        try {
            this.checkResultSet();
            return new RowIterator(Query.buildColumnMap(this.resultSet), this.resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public void reUse() {
        if (this.resultSet != null) {
            ConnectionManager.close(this.resultSet, null, null);
            this.resultSet = null;
        }
        this.resultListMap.clear();
    }

    private void checkResultSet() throws SQLException {
        if (this.resultSet != null) {
            return;
        }
        if (this.maxResults != -1) {
            this.statement.setFetchSize(this.maxResults);
        }
        this.resultSet = this.statement.executeQuery();
    }

    public <T> T getFirstResult(Class<T> beanClass) throws Exception {
        List<T> list = this.getResultList(beanClass);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public <T> List<T> getResultList(Class<T> beanClass) throws Exception {
        List<Object> resultList = this.resultListMap.get(beanClass);
        if (resultList != null) {
            return resultList;
        }
        this.checkResultSet();
        resultList = this.createBeanList(beanClass);
        this.resultListMap.put(beanClass, resultList);
        return resultList;
    }

    public List<Row> getResultList() throws SQLException {
        this.checkResultSet();
        return this.createRowList(this.maxResults);
    }

    public Row getFirstResult() throws SQLException {
        this.checkResultSet();
        List<Row> rows = this.createRowList(1);
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        return rows.get(0);
    }

    public int update() throws SQLException {
        return this.statement.executeUpdate();
    }

    public List<Row> getGeneratedKeys() throws SQLException {
        return Query.createRowList(this.statement.getGeneratedKeys(), -1);
    }

    public int getResultCount() throws SQLException {
        this.checkResultSet();
        this.resultSet.last();
        return this.resultSet.getRow();
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkResultSet();
        return this.resultSet;
    }

    private class MethodColumnIndex {
        private int columnIndex;
        private Method method;

        private MethodColumnIndex(int columnIndex, Method method) {
            this.columnIndex = columnIndex;
            this.method = method;
        }

        private void invoke(Object bean, ResultSet resultSet) throws Exception {
            if (this.method == null) {
                return;
            }
            Object colObject = resultSet.getObject(this.columnIndex);
            try {
                if (colObject != null) {
                    this.method.invoke(bean, colObject);
                }
            }
            catch (Exception e) {
                if (this.method == null) {
                    throw new Exception("No method found for column " + this.columnIndex, e);
                }
                throw new Exception("Error on column " + this.columnIndex + " method " + this.method.getName() + (colObject == null ? "" : " object class is " + colObject.getClass().getName()), e);
            }
        }
    }
}

