/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Row
extends AbstractMap<String, Object> {
    final Map<String, Integer> columnMap;
    final Object[] columns;

    Row(Map<String, Integer> columnMap) {
        this.columnMap = columnMap;
        this.columns = new Object[columnMap.size()];
    }

    Row(Map<String, Integer> columnMap, ResultSet rs) throws SQLException {
        this(columnMap);
        for (Map.Entry<String, Integer> entry : columnMap.entrySet()) {
            Object object;
            int columnIndex = entry.getValue();
            this.columns[columnIndex] = object = rs.getObject(columnIndex + 1);
        }
    }

    public final Object get(int columnNumber) {
        Object col = this.columns[columnNumber];
        if (col == null) {
            return null;
        }
        return col;
    }

    @Override
    public final Object get(Object label) {
        Integer colNumber = this.columnMap.get(label.toString());
        if (colNumber == null) {
            return null;
        }
        if (colNumber > this.columns.length) {
            return null;
        }
        return this.columns[colNumber];
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException("This map cannot export its entry set");
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.columns == null) {
            return false;
        }
        for (Object col : this.columns) {
            if (col != value) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getColumns() {
        return this.columnMap.keySet();
    }
}

