/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.jdbc;

import com.qwazr.utils.jdbc.Query;
import com.qwazr.utils.jdbc.connection.ConnectionManager;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;

public class Transaction
implements Closeable {
    private Connection cnx;
    private HashSet<Query> queries;

    public Transaction(Connection cnx, boolean autoCommit, Integer transactionIsolation) throws SQLException {
        this.cnx = cnx;
        if (transactionIsolation != null) {
            cnx.setTransactionIsolation(transactionIsolation);
        }
        cnx.setAutoCommit(autoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeQuery(Query query) {
        Transaction transaction = this;
        synchronized (transaction) {
            query.closeAll();
            this.queries.remove(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeQueries() {
        Transaction transaction = this;
        synchronized (transaction) {
            if (this.queries == null) {
                return;
            }
            for (Query query : this.queries) {
                query.closeAll();
            }
            this.queries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Transaction transaction = this;
        synchronized (transaction) {
            if (this.cnx == null) {
                return;
            }
            Connection connection = this.cnx;
            synchronized (connection) {
                this.closeQueries();
                ConnectionManager.close(null, null, this.cnx);
                this.cnx = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Connection connection = this.cnx;
        synchronized (connection) {
            this.cnx.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        Connection connection = this.cnx;
        synchronized (connection) {
            this.cnx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addQuery(Query query) {
        Transaction transaction = this;
        synchronized (transaction) {
            if (this.queries == null) {
                this.queries = new HashSet();
            }
            this.queries.add(query);
        }
    }

    public Query prepare(String sql) throws SQLException {
        Query query = new Query(this.cnx.prepareStatement(sql));
        this.addQuery(query);
        return query;
    }

    public Query prepareWithKeys(String sql) throws SQLException {
        Query query = new Query(this.cnx.prepareStatement(sql, 1));
        this.addQuery(query);
        return query;
    }

    public Query prepare(String sql, int resultSetType, int resultSetConcurency) throws SQLException {
        Query query = new Query(this.cnx.prepareStatement(sql, resultSetType, resultSetConcurency));
        this.addQuery(query);
        return query;
    }

    public int update(String sql) throws SQLException {
        return this.prepare(sql).update();
    }
}

