/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.jdbc.connection;

import com.qwazr.utils.jdbc.Transaction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConnectionManager {
    protected static final Logger logger = Logger.getLogger(ConnectionManager.class.getCanonicalName());

    public abstract Transaction getNewTransaction(boolean var1, Integer var2) throws SQLException;

    public Transaction getNewTransaction(boolean autoCommit) throws SQLException {
        return this.getNewTransaction(autoCommit, null);
    }

    public Transaction getNewTransaction() throws SQLException {
        return this.getNewTransaction(true);
    }

    public static void close(ResultSet resultSet, Statement stmt, Connection cnx) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (cnx != null) {
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Close JDBC connection");
                }
                cnx.close();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

