/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.jdbc.connection;

import com.qwazr.utils.ClassLoaderUtils;
import com.qwazr.utils.jdbc.Transaction;
import com.qwazr.utils.jdbc.connection.ConnectionManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;

public class JDBCConnection
extends ConnectionManager {
    private String url;
    private String driver;
    private String username;
    private String password;

    public JDBCConnection() {
        this.url = null;
        this.driver = null;
    }

    public JDBCConnection(ClassLoader classLoader, String driver, String url) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.setDriver(classLoader, driver);
        this.setUrl(url);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(ClassLoader classLoader, String driver) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("New Database instance - Driver: " + driver + " Url: " + this.url);
        }
        if (driver != null) {
            ClassLoaderUtils.findClass(classLoader, driver).newInstance();
        }
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Transaction getNewTransaction(boolean autoCommit, Integer transactionIsolation) throws SQLException {
        return this.getNewTransaction(autoCommit, transactionIsolation, null);
    }

    public Transaction getNewTransaction(boolean autoCommit, Integer transactionIsolation, String urlSuffix) throws SQLException {
        String localUrl = this.url;
        if (urlSuffix != null) {
            localUrl = localUrl + urlSuffix;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("DriverManager.getConnection " + localUrl);
        }
        Connection cnx = null;
        cnx = this.username != null || this.password != null ? DriverManager.getConnection(localUrl, this.username, this.password) : DriverManager.getConnection(localUrl);
        if (transactionIsolation != null) {
            cnx.setTransactionIsolation(transactionIsolation);
        }
        cnx.setAutoCommit(autoCommit);
        return new Transaction(cnx, autoCommit, transactionIsolation);
    }
}

