/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.json;

import com.qwazr.utils.json.JsonFileFilter;
import com.qwazr.utils.json.JsonMapper;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DirectoryJsonManager<T> {
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final File directory;
    private final Map<String, Pair<Long, T>> instancesMap;
    private volatile Map<String, Pair<Long, T>> instancesCache;
    private final Class<T> instanceClass;

    protected DirectoryJsonManager(File directory, Class<T> instanceClass) throws IOException {
        this.instanceClass = instanceClass;
        this.directory = directory;
        this.instancesMap = new LinkedHashMap<String, Pair<Long, T>>();
        this.load();
    }

    private File getFile(String name) {
        return new File(this.directory, name + ".json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws IOException {
        try {
            File[] files = this.directory.listFiles(JsonFileFilter.INSTANCE);
            if (files == null) {
                return;
            }
            for (File file : files) {
                String name = file.getName();
                name = name.substring(0, name.length() - 5);
                this.loadItem(name, file, file.lastModified());
            }
        }
        finally {
            this.buildCache();
        }
    }

    private Pair<Long, T> loadItem(String name, File file, long lastModified) throws IOException {
        T item = JsonMapper.MAPPER.readValue(file, this.instanceClass);
        return this.put(name, lastModified, item);
    }

    private void buildCache() {
        this.instancesCache = new LinkedHashMap<String, Pair<Long, T>>(this.instancesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T delete(String name) throws IOException {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        name = name.intern();
        this.rwl.writeLock().lock();
        try {
            this.getFile(name).delete();
            Pair<Long, T> instance = this.instancesMap.remove(name);
            this.buildCache();
            T t = instance.getRight();
            return t;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private Pair<Long, T> put(String name, long lastModified, T instance) {
        name = name.intern();
        Pair<Long, T> item = Pair.of(lastModified, instance);
        this.instancesMap.put(name, item);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String name, T instance) throws IOException {
        if (instance == null) {
            return;
        }
        if (StringUtils.isEmpty(name)) {
            return;
        }
        this.rwl.writeLock().lock();
        try {
            File destFile = this.getFile(name);
            JsonMapper.MAPPER.writeValue(destFile, instance);
            this.put(name, destFile.lastModified(), instance);
            this.buildCache();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private T getNoLock(File file, String name, AtomicBoolean mustBeEvaluated) throws IOException {
        Pair<Long, T> item = this.instancesCache.get(name);
        long lastModified = file.lastModified();
        if (file.exists()) {
            if (item != null && item.getLeft() == lastModified) {
                return item.getRight();
            }
            if (mustBeEvaluated == null) {
                item = this.loadItem(name, file, lastModified);
                this.buildCache();
                return item.getRight();
            }
        } else {
            if (item == null) {
                return null;
            }
            if (mustBeEvaluated == null) {
                this.instancesMap.remove(name);
                this.buildCache();
                return null;
            }
        }
        mustBeEvaluated.set(true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T get(String name) throws IOException {
        File file = this.getFile(name);
        this.rwl.readLock().lock();
        try {
            AtomicBoolean mustBeEvaluated = new AtomicBoolean(false);
            T item = this.getNoLock(file, name, mustBeEvaluated);
            if (!mustBeEvaluated.get()) {
                T t = item;
                return t;
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        this.rwl.writeLock().lock();
        try {
            T t = this.getNoLock(file, name, null);
            return t;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    protected Set<String> nameSet() {
        return this.instancesCache.keySet();
    }
}

