/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.process;

import com.qwazr.utils.IOUtils;
import com.qwazr.utils.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;

public class PIDFile {
    private final Integer pid = PIDFile.getPid();
    private final File pidFile = PIDFile.getPidFile();

    public boolean isFileExists() {
        if (this.pidFile == null) {
            return false;
        }
        return this.pidFile.exists();
    }

    public PIDFile savePidToFile() throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.pidFile);){
            IOUtils.write(this.pid.toString(), (OutputStream)fos, Charset.defaultCharset());
            PIDFile pIDFile = this;
            return pIDFile;
        }
    }

    public PIDFile deletePidFileOnExit() {
        if (this.pidFile != null) {
            this.pidFile.deleteOnExit();
        }
        return this;
    }

    public static File getPidFile() {
        String pid_path = System.getProperty("com.qwazr.pid.path");
        if (pid_path == null) {
            pid_path = System.getenv("QWAZR_PID_PATH");
        }
        if (pid_path == null) {
            return null;
        }
        return new File(pid_path);
    }

    public static Integer getPid() {
        String pid = System.getProperty("com.qwazr.pid");
        if (!StringUtils.isEmpty(pid)) {
            pid = System.getenv("QWAZR_PID");
        }
        if (!StringUtils.isEmpty(pid)) {
            return Integer.parseInt(pid);
        }
        return PIDFile.getPidFromMxBean();
    }

    public static Integer getPidFromMxBean() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (name == null) {
            return null;
        }
        int i = name.indexOf(64);
        if (i == -1) {
            return null;
        }
        return Integer.parseInt(name.substring(0, i));
    }

    public String toString() {
        return "PID: " + this.pid + " - File: " + this.pidFile;
    }
}

