/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils.process;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;

public class ProcessUtils {
    public static final String NOT_SUPPORTED_ERROR = "Process command unsupported on this operating system";

    public static Integer kill(Number pid) throws IOException, InterruptedException {
        String commandLine;
        if (pid == null) {
            return null;
        }
        if (SystemUtils.IS_OS_UNIX) {
            commandLine = "kill  " + pid;
        } else if (SystemUtils.IS_OS_WINDOWS) {
            commandLine = "taskkill /PID " + pid;
        } else {
            throw new IOException(NOT_SUPPORTED_ERROR);
        }
        return ProcessUtils.run(commandLine);
    }

    public static Integer forceKill(Number pid) throws IOException, InterruptedException {
        String commandLine;
        if (pid == null) {
            return null;
        }
        if (SystemUtils.IS_OS_UNIX) {
            commandLine = "kill -9 " + pid;
        } else if (SystemUtils.IS_OS_WINDOWS) {
            commandLine = "taskkill /F /PID " + pid;
        } else {
            throw new IOException(NOT_SUPPORTED_ERROR);
        }
        return ProcessUtils.run(commandLine);
    }

    public static Boolean isRunning(Number pid) throws IOException, InterruptedException {
        if (pid == null) {
            return null;
        }
        if (!SystemUtils.IS_OS_UNIX) {
            throw new IOException(NOT_SUPPORTED_ERROR);
        }
        String commandLine = "kill -0 " + pid;
        Integer res = ProcessUtils.run(commandLine);
        if (res == null) {
            return null;
        }
        return res == 0;
    }

    public static Integer run(String commandLine) throws InterruptedException, IOException {
        Process process = Runtime.getRuntime().exec(commandLine);
        try {
            Integer n = process.waitFor();
            return n;
        }
        finally {
            process.destroy();
            if (process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    public static Process java(Class<?> javaClass, Map<String, String> env) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        ProcessBuilder builder = new ProcessBuilder(javaBin, "-cp", classpath, javaClass.getCanonicalName());
        if (env != null) {
            builder.environment().putAll(env);
        }
        builder.inheritIO();
        return builder.start();
    }
}

