/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

public class DeflatingStreamSinkConduit
implements StreamSinkConduit {
    protected final Deflater deflater;
    private final ConduitFactory<StreamSinkConduit> conduitFactory;
    private final HttpServerExchange exchange;
    private StreamSinkConduit next;
    private WriteReadyHandler writeReadyHandler;
    protected PooledByteBuffer currentBuffer;
    private ByteBuffer additionalBuffer;
    private int state = 0;
    private static final int SHUTDOWN = 1;
    private static final int NEXT_SHUTDOWN = 2;
    private static final int FLUSHING_BUFFER = 4;
    private static final int WRITES_RESUMED = 8;
    private static final int CLOSED = 16;
    private static final int WRITTEN_TRAILER = 32;

    public DeflatingStreamSinkConduit(ConduitFactory<StreamSinkConduit> conduitFactory, HttpServerExchange exchange) {
        this(conduitFactory, exchange, 8);
    }

    protected DeflatingStreamSinkConduit(ConduitFactory<StreamSinkConduit> conduitFactory, HttpServerExchange exchange, int deflateLevel) {
        this.deflater = new Deflater(deflateLevel, true);
        this.currentBuffer = exchange.getConnection().getByteBufferPool().allocate();
        this.exchange = exchange;
        this.conduitFactory = conduitFactory;
        this.setWriteReadyHandler(new WriteReadyHandler.ChannelListenerHandler<ConduitStreamSinkChannel>(Connectors.getConduitSinkChannel(exchange)));
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(this.state, 17) || this.currentBuffer == null) {
            throw new ClosedChannelException();
        }
        try {
            if (!this.performFlushIfRequired()) {
                return 0;
            }
            if (src.remaining() == 0) {
                return 0;
            }
            if (!this.deflater.needsInput()) {
                this.deflateData(false);
                if (!this.deflater.needsInput()) {
                    return 0;
                }
            }
            byte[] data = new byte[src.remaining()];
            src.get(data);
            this.preDeflate(data);
            this.deflater.setInput(data);
            Connectors.updateResponseBytesSent(this.exchange, 0 - data.length);
            this.deflateData(false);
            return data.length;
        }
        catch (IOException e) {
            this.freeBuffer();
            throw e;
        }
    }

    protected void preDeflate(byte[] data) {
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (Bits.anyAreSet(this.state, 17) || this.currentBuffer == null) {
            throw new ClosedChannelException();
        }
        try {
            int total = 0;
            for (int i = offset; i < offset + length; ++i) {
                if (!srcs[i].hasRemaining()) continue;
                int ret = this.write(srcs[i]);
                total += ret;
                if (ret != 0) continue;
                return total;
            }
            return total;
        }
        catch (IOException e) {
            this.freeBuffer();
            throw e;
        }
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(this.state, 17)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0L;
        }
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet(this.state, 17)) {
            throw new ClosedChannelException();
        }
        if (!this.performFlushIfRequired()) {
            return 0L;
        }
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public XnioWorker getWorker() {
        return this.exchange.getConnection().getWorker();
    }

    @Override
    public void suspendWrites() {
        if (this.next == null) {
            this.state &= 0xFFFFFFF7;
        } else {
            this.next.suspendWrites();
        }
    }

    @Override
    public boolean isWriteResumed() {
        if (this.next == null) {
            return Bits.anyAreSet(this.state, 8);
        }
        return this.next.isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        if (this.next == null) {
            this.resumeWrites();
        } else {
            this.next.wakeupWrites();
        }
    }

    @Override
    public void resumeWrites() {
        if (this.next == null) {
            this.state |= 8;
            this.queueWriteListener();
        } else {
            this.next.resumeWrites();
        }
    }

    private void queueWriteListener() {
        this.exchange.getConnection().getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                if (DeflatingStreamSinkConduit.this.writeReadyHandler != null) {
                    try {
                        DeflatingStreamSinkConduit.this.writeReadyHandler.writeReady();
                    }
                    finally {
                        if (DeflatingStreamSinkConduit.this.next == null && DeflatingStreamSinkConduit.this.isWriteResumed()) {
                            DeflatingStreamSinkConduit.this.queueWriteListener();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void terminateWrites() throws IOException {
        this.deflater.finish();
        this.state |= 1;
    }

    @Override
    public boolean isWriteShutdown() {
        return Bits.anyAreSet(this.state, 1);
    }

    @Override
    public void awaitWritable() throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.awaitWritable(time, timeUnit);
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.exchange.getConnection().getIoThread();
    }

    @Override
    public void setWriteReadyHandler(WriteReadyHandler handler) {
        this.writeReadyHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean flush() throws IOException {
        if (this.currentBuffer == null) {
            if (!Bits.anyAreSet(this.state, 2)) return true;
            return this.next.flush();
        }
        try {
            boolean nextCreated = false;
            try {
                if (Bits.anyAreSet(this.state, 1)) {
                    if (Bits.anyAreSet(this.state, 2)) {
                        boolean bl = this.next.flush();
                        return bl;
                    }
                    if (!this.performFlushIfRequired()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.deflater.finished()) {
                        this.deflateData(false);
                        if (!this.deflater.finished()) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    ByteBuffer buffer = this.currentBuffer.getBuffer();
                    if (Bits.allAreClear(this.state, 32)) {
                        this.state |= 0x20;
                        byte[] data = this.getTrailer();
                        if (data != null) {
                            Connectors.updateResponseBytesSent(this.exchange, data.length);
                            if (this.additionalBuffer != null) {
                                byte[] newData = new byte[this.additionalBuffer.remaining() + data.length];
                                int pos = 0;
                                while (this.additionalBuffer.hasRemaining()) {
                                    newData[pos++] = this.additionalBuffer.get();
                                }
                                for (byte aData : data) {
                                    newData[pos++] = aData;
                                }
                                this.additionalBuffer = ByteBuffer.wrap(newData);
                            } else if (Bits.anyAreSet(this.state, 4) && buffer.capacity() - buffer.remaining() >= data.length) {
                                buffer.compact();
                                buffer.put(data);
                                buffer.flip();
                            } else if (data.length <= buffer.remaining() && !Bits.anyAreSet(this.state, 4)) {
                                buffer.put(data);
                            } else {
                                this.additionalBuffer = ByteBuffer.wrap(data);
                            }
                        }
                    }
                    if (!Bits.anyAreSet(this.state, 4)) {
                        buffer.flip();
                        this.state |= 4;
                        if (this.next == null) {
                            nextCreated = true;
                            this.next = this.createNextChannel();
                        }
                    }
                    if (this.performFlushIfRequired()) {
                        this.state |= 2;
                        this.freeBuffer();
                        this.next.terminateWrites();
                        boolean data = this.next.flush();
                        return data;
                    }
                    boolean data = false;
                    return data;
                }
                if (Bits.allAreClear(this.state, 4)) {
                    if (this.next == null) {
                        nextCreated = true;
                        this.next = this.createNextChannel();
                    }
                    this.deflateData(true);
                    if (Bits.allAreClear(this.state, 4)) {
                        this.currentBuffer.getBuffer().flip();
                        this.state |= 4;
                    }
                }
                if (!this.performFlushIfRequired()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.next.flush();
                return bl;
            }
            finally {
                if (nextCreated && Bits.anyAreSet(this.state, 8) && !Bits.anyAreSet(this.state, 2)) {
                    try {
                        this.next.resumeWrites();
                    }
                    catch (Exception e) {
                        UndertowLogger.REQUEST_LOGGER.debug("Failed to resume", e);
                    }
                }
            }
        }
        catch (IOException e) {
            this.freeBuffer();
            throw e;
        }
    }

    protected byte[] getTrailer() {
        return null;
    }

    private boolean performFlushIfRequired() throws IOException {
        if (Bits.anyAreSet(this.state, 4)) {
            ByteBuffer[] bufs = new ByteBuffer[this.additionalBuffer == null ? 1 : 2];
            long totalLength = 0L;
            bufs[0] = this.currentBuffer.getBuffer();
            totalLength += (long)bufs[0].remaining();
            if (this.additionalBuffer != null) {
                bufs[1] = this.additionalBuffer;
                totalLength += (long)bufs[1].remaining();
            }
            if (totalLength > 0L) {
                long total = 0L;
                long res = 0L;
                do {
                    res = this.next.write(bufs, 0, bufs.length);
                    total += res;
                    if (res != 0L) continue;
                    return false;
                } while (total < totalLength);
            }
            this.additionalBuffer = null;
            this.currentBuffer.getBuffer().clear();
            this.state &= 0xFFFFFFFB;
        }
        return true;
    }

    private StreamSinkConduit createNextChannel() {
        if (this.deflater.finished() && Bits.allAreSet(this.state, 32)) {
            int remaining = this.currentBuffer.getBuffer().remaining();
            if (this.additionalBuffer != null) {
                remaining += this.additionalBuffer.remaining();
            }
            this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Integer.toString(remaining));
        } else {
            this.exchange.getResponseHeaders().remove(Headers.CONTENT_LENGTH);
        }
        return this.conduitFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deflateData(boolean force) throws IOException {
        boolean nextCreated = false;
        try (PooledByteBuffer arrayPooled = this.exchange.getConnection().getByteBufferPool().getArrayBackedPool().allocate();){
            PooledByteBuffer pooled = this.currentBuffer;
            ByteBuffer outputBuffer = pooled.getBuffer();
            boolean shutdown = Bits.anyAreSet(this.state, 1);
            ByteBuffer buf = arrayPooled.getBuffer();
            while (force || !this.deflater.needsInput() || shutdown && !this.deflater.finished()) {
                int count = this.deflater.deflate(buf.array(), buf.arrayOffset(), buf.remaining(), force ? 2 : 0);
                Connectors.updateResponseBytesSent(this.exchange, count);
                if (count != 0) {
                    int remaining = outputBuffer.remaining();
                    if (remaining > count) {
                        outputBuffer.put(buf.array(), buf.arrayOffset(), count);
                        continue;
                    }
                    if (remaining == count) {
                        outputBuffer.put(buf.array(), buf.arrayOffset(), count);
                    } else {
                        outputBuffer.put(buf.array(), buf.arrayOffset(), remaining);
                        this.additionalBuffer = ByteBuffer.allocate(count - remaining);
                        this.additionalBuffer.put(buf.array(), buf.arrayOffset() + remaining, count - remaining);
                        this.additionalBuffer.flip();
                    }
                    outputBuffer.flip();
                    this.state |= 4;
                    if (this.next == null) {
                        nextCreated = true;
                        this.next = this.createNextChannel();
                    }
                    if (this.performFlushIfRequired()) continue;
                    return;
                }
                force = false;
            }
        }
        finally {
            if (nextCreated && Bits.anyAreSet(this.state, 8)) {
                this.next.resumeWrites();
            }
        }
    }

    @Override
    public void truncateWrites() throws IOException {
        this.freeBuffer();
        this.state |= 0x10;
        this.next.truncateWrites();
    }

    private void freeBuffer() {
        if (this.currentBuffer != null) {
            this.currentBuffer.close();
            this.currentBuffer = null;
            this.state &= 0xFFFFFFFB;
        }
    }
}

