/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.osgi.logservice.impl;

import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.log.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogServiceImpl
implements LogService {
    private static final String UNKNOWN = "[Unknown]";
    private final Logger delegate;

    public LogServiceImpl(Bundle bundle2) {
        String name = bundle2.getSymbolicName();
        Version version = bundle2.getVersion();
        if (version == null) {
            version = Version.emptyVersion;
        }
        this.delegate = LoggerFactory.getLogger(name + '.' + version);
    }

    public void log(int level, String message) {
        switch (level) {
            case 4: {
                this.delegate.debug(message);
                break;
            }
            case 1: {
                this.delegate.error(message);
                break;
            }
            case 3: {
                this.delegate.info(message);
                break;
            }
            case 2: {
                this.delegate.warn(message);
                break;
            }
        }
    }

    public void log(int level, String message, Throwable exception) {
        switch (level) {
            case 4: {
                this.delegate.debug(message, exception);
                break;
            }
            case 1: {
                this.delegate.error(message, exception);
                break;
            }
            case 3: {
                this.delegate.info(message, exception);
                break;
            }
            case 2: {
                this.delegate.warn(message, exception);
                break;
            }
        }
    }

    public void log(ServiceReference sr, int level, String message) {
        switch (level) {
            case 4: {
                if (!this.delegate.isDebugEnabled()) break;
                this.delegate.debug(this.createMessage(sr, message));
                break;
            }
            case 1: {
                if (!this.delegate.isErrorEnabled()) break;
                this.delegate.error(this.createMessage(sr, message));
                break;
            }
            case 3: {
                if (!this.delegate.isInfoEnabled()) break;
                this.delegate.info(this.createMessage(sr, message));
                break;
            }
            case 2: {
                if (!this.delegate.isWarnEnabled()) break;
                this.delegate.warn(this.createMessage(sr, message));
                break;
            }
        }
    }

    private String createMessage(ServiceReference sr, String message) {
        StringBuilder output = new StringBuilder();
        if (sr != null) {
            output.append('[').append(sr.toString()).append(']');
        } else {
            output.append(UNKNOWN);
        }
        output.append(message);
        return output.toString();
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        switch (level) {
            case 4: {
                if (!this.delegate.isDebugEnabled()) break;
                this.delegate.debug(this.createMessage(sr, message), exception);
                break;
            }
            case 1: {
                if (!this.delegate.isErrorEnabled()) break;
                this.delegate.error(this.createMessage(sr, message), exception);
                break;
            }
            case 3: {
                if (!this.delegate.isInfoEnabled()) break;
                this.delegate.info(this.createMessage(sr, message), exception);
                break;
            }
            case 2: {
                if (!this.delegate.isWarnEnabled()) break;
                this.delegate.warn(this.createMessage(sr, message), exception);
                break;
            }
        }
    }
}

