/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.fasterxml.jackson.databind.JsonNode;
import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.store.CollectorInterface;
import com.qwazr.database.store.Query;
import com.qwazr.database.store.QueryResult;
import com.qwazr.database.store.Table;
import com.qwazr.database.store.ValueConsumer;
import com.qwazr.graph.model.GraphDefinition;
import com.qwazr.graph.model.GraphNode;
import com.qwazr.graph.model.GraphNodeResult;
import com.qwazr.graph.model.GraphRequest;
import com.qwazr.server.ServerException;
import com.qwazr.utils.LoggerUtils;
import com.qwazr.utils.StringUtils;
import com.qwazr.utils.concurrent.RunnablePool;
import com.qwazr.utils.concurrent.RunnablePoolException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.roaringbitmap.RoaringBitmap;

public class GraphInstance {
    private static final Logger logger = LoggerUtils.getLogger(GraphInstance.class);
    static final String FIELD_PREFIX_PROPERTY = "prop.";
    static final String FIELD_PREFIX_EDGE = "edge.";
    private final ExecutorService executorService;
    private final Table table;
    private final GraphDefinition graphDef;

    static String getPropertyField(String name) {
        return StringUtils.fastConcat((CharSequence[])new CharSequence[]{FIELD_PREFIX_PROPERTY, name});
    }

    static String getEdgeField(String name) {
        return StringUtils.fastConcat((CharSequence[])new CharSequence[]{FIELD_PREFIX_EDGE, name});
    }

    GraphInstance(ExecutorService executorService, Table table, GraphDefinition graphDef) {
        this.executorService = executorService;
        this.table = table;
        this.graphDef = graphDef;
    }

    void checkFields() throws ServerException, IOException {
        String fieldName;
        Map existingColumns = this.table.getColumns();
        LinkedHashMap<String, ColumnDefinition> columnDefinitions = new LinkedHashMap<String, ColumnDefinition>();
        if (this.graphDef.node_properties != null) {
            for (Map.Entry entry : this.graphDef.node_properties.entrySet()) {
                fieldName = GraphInstance.getPropertyField((String)entry.getKey());
                switch ((GraphDefinition.PropertyTypeEnum)((Object)entry.getValue())) {
                    case indexed: {
                        columnDefinitions.put(fieldName, new ColumnDefinition(ColumnDefinition.Type.STRING, ColumnDefinition.Mode.INDEXED));
                        break;
                    }
                    case stored: {
                        columnDefinitions.put(fieldName, new ColumnDefinition(ColumnDefinition.Type.STRING, ColumnDefinition.Mode.STORED));
                        break;
                    }
                    case boost: {
                        columnDefinitions.put(fieldName, new ColumnDefinition(ColumnDefinition.Type.DOUBLE, ColumnDefinition.Mode.INDEXED));
                    }
                }
            }
        }
        if (this.graphDef.edge_types != null) {
            for (String string : this.graphDef.edge_types) {
                fieldName = GraphInstance.getEdgeField(string);
                columnDefinitions.put(fieldName, new ColumnDefinition(ColumnDefinition.Type.STRING, ColumnDefinition.Mode.INDEXED));
            }
        }
        try {
            for (Map.Entry entry : columnDefinitions.entrySet()) {
                if (existingColumns.containsKey(entry.getKey())) continue;
                this.table.setColumn((String)entry.getKey(), (ColumnDefinition)entry.getValue());
            }
        }
        catch (Exception e) {
            throw ServerException.of((Throwable)e);
        }
    }

    private static void createUpdate(Table table, GraphDefinition graphDef, String node_id, GraphNode node) throws ServerException, IOException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        if (node.properties != null && !node.properties.isEmpty()) {
            if (graphDef.node_properties == null) {
                throw new ServerException(Response.Status.BAD_REQUEST, "This graph database does not define any property.");
            }
            for (Map.Entry<String, Object> entry : node.properties.entrySet()) {
                String field = entry.getKey();
                if (!graphDef.node_properties.containsKey(field)) {
                    throw new ServerException(Response.Status.BAD_REQUEST, "Unknown property name: " + field);
                }
                row.put(GraphInstance.getPropertyField(field), entry.getValue());
            }
        }
        if (node.edges != null && !node.edges.isEmpty()) {
            if (graphDef.edge_types == null) {
                throw new ServerException(Response.Status.BAD_REQUEST, "This graph database does not define any edge.");
            }
            for (Map.Entry<String, Object> entry : node.edges.entrySet()) {
                String type = entry.getKey();
                if (!graphDef.edge_types.contains(type)) {
                    throw new ServerException(Response.Status.BAD_REQUEST, "Unknown edge type: " + type);
                }
                if (entry.getValue() == null) continue;
                row.put(GraphInstance.getEdgeField(type), entry.getValue());
            }
        }
        table.upsertRow(node_id, row);
    }

    void createUpdateNode(String node_id, GraphNode node, Boolean upsert) throws ServerException, IOException {
        block4: {
            if (node == null) {
                return;
            }
            if (upsert != null && upsert.booleanValue()) {
                try {
                    node.add(this.getNode(node_id));
                }
                catch (ServerException e) {
                    if (e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) break block4;
                    throw e;
                }
            }
        }
        GraphInstance.createUpdate(this.table, this.graphDef, node_id, node);
    }

    void createUpdateNodes(Map<String, GraphNode> nodes, Boolean upsert) throws IOException, URISyntaxException {
        Map<String, GraphNode> dbNodes;
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        logger.info(() -> "Update " + nodes.size() + " node(s)");
        if (upsert != null && upsert.booleanValue() && (dbNodes = this.getNodes(nodes.keySet())) != null) {
            for (Map.Entry<String, GraphNode> entry : nodes.entrySet()) {
                GraphNode dbNode = dbNodes.get(entry.getKey());
                if (dbNode == null) continue;
                entry.getValue().add(dbNode);
            }
        }
        for (Map.Entry<String, GraphNode> entry : nodes.entrySet()) {
            GraphInstance.createUpdate(this.table, this.graphDef, entry.getKey(), entry.getValue());
        }
    }

    private void populateReturnedFields(Collection<String> returnedFields) {
        if (this.graphDef.node_properties != null) {
            for (String name : this.graphDef.node_properties.keySet()) {
                returnedFields.add(GraphInstance.getPropertyField(name));
            }
        }
        if (this.graphDef.edge_types != null) {
            for (String type : this.graphDef.edge_types) {
                returnedFields.add(GraphInstance.getEdgeField(type));
            }
        }
    }

    private void populateGraphNode(Map<String, ?> document, GraphNode node) {
        if (document == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : document.entrySet()) {
            String field = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof List) {
                List values = (List)value;
                if (values.isEmpty()) continue;
                if (field.startsWith(FIELD_PREFIX_PROPERTY)) {
                    node.addProperty(field.substring(FIELD_PREFIX_PROPERTY.length()), values.get(0));
                } else if (field.startsWith(FIELD_PREFIX_EDGE)) {
                    for (Object val : values) {
                        node.addEdge(field.substring(FIELD_PREFIX_EDGE.length()), val);
                    }
                }
            }
            if (field.startsWith(FIELD_PREFIX_PROPERTY)) {
                node.addProperty(field.substring(FIELD_PREFIX_PROPERTY.length()), value);
                continue;
            }
            if (!field.startsWith(FIELD_PREFIX_EDGE)) continue;
            node.addEdge(field.substring(FIELD_PREFIX_EDGE.length()), value);
        }
    }

    GraphNode getNode(String node_id) throws IOException {
        LinkedHashSet<String> returnedFields = new LinkedHashSet<String>();
        this.populateReturnedFields(returnedFields);
        LinkedHashMap document = this.table.getRow(node_id, returnedFields);
        if (document == null) {
            throw new ServerException(Response.Status.NOT_FOUND, "Node not found: " + node_id);
        }
        GraphNode node = new GraphNode();
        this.populateGraphNode(document, node);
        return node;
    }

    Map<String, GraphNode> getNodes(Set<String> node_ids) throws IOException, URISyntaxException {
        LinkedHashSet<String> returnedFields = new LinkedHashSet<String>();
        this.populateReturnedFields(returnedFields);
        ArrayList documents = new ArrayList();
        this.table.getRows(node_ids, returnedFields, documents);
        if (documents.isEmpty()) {
            return null;
        }
        Iterator<String> iteratorId = node_ids.iterator();
        LinkedHashMap<String, GraphNode> graphNodes = new LinkedHashMap<String, GraphNode>();
        for (Map document : documents) {
            GraphNode node = new GraphNode();
            this.populateGraphNode(document, node);
            graphNodes.put(iteratorId.next(), node);
        }
        return graphNodes;
    }

    GraphNode createEdge(String node_id, String type, String to_node_id) throws IOException {
        if (this.graphDef.edge_types == null || this.graphDef.edge_types.isEmpty()) {
            throw new ServerException(Response.Status.BAD_REQUEST, "This base did not define any edge type");
        }
        if (!this.graphDef.isEdgeType(type)) {
            throw new ServerException(Response.Status.BAD_REQUEST, "Unknown edge type: " + type);
        }
        GraphNode node = this.getNode(node_id);
        if (!node.addEdge(type, to_node_id)) {
            return node;
        }
        this.createUpdateNode(node_id, node, false);
        return node;
    }

    public GraphNode deleteEdge(String node_id, String type, String to_node_id) throws IOException, URISyntaxException {
        GraphNode node = this.getNode(node_id);
        if (!node.removeEdge(type, to_node_id)) {
            return node;
        }
        this.createUpdateNode(node_id, node, false);
        return node;
    }

    void deleteNode(String node_id) throws IOException {
        if (!this.table.deleteRow(node_id)) {
            throw new ServerException(Response.Status.NOT_FOUND, "Node not found: " + node_id);
        }
    }

    public List<GraphNodeResult> request(GraphRequest request) throws IOException, URISyntaxException {
        HashSet<String> boostFields;
        RoaringBitmap filterBitset;
        QueryResult result;
        Set<String> edge_set;
        ArrayList<GraphNodeResult> resultList = new ArrayList<GraphNodeResult>(request.getRowsOrDefault());
        HashMap<String, Map> facetFields = new HashMap<String, Map>();
        Query.OrGroup orGroup = null;
        if (request.edges != null && !request.edges.isEmpty()) {
            for (Map.Entry<String, Set<String>> entry : request.edges.entrySet()) {
                String edge_type = entry.getKey();
                String field = GraphInstance.getEdgeField(edge_type);
                HashMap termCount = new HashMap();
                facetFields.put(field, termCount);
                edge_set = entry.getValue();
                if (edge_set == null || edge_set.isEmpty()) continue;
                if (!this.graphDef.isEdgeType(edge_type)) {
                    throw new ServerException(Response.Status.BAD_REQUEST, "Unknown edge type: " + edge_type);
                }
                if (edge_set == null || edge_set.isEmpty()) continue;
                if (orGroup == null) {
                    orGroup = new Query.OrGroup();
                }
                for (String term : edge_set) {
                    orGroup.add((Query)new Query.TermQuery(field, (Object)term));
                }
            }
        }
        if ((result = this.table.query(orGroup, facetFields)) == null || result.finalBitmap == null || result.finalBitmap.isEmpty()) {
            return resultList;
        }
        if (request.filters != null) {
            Query query = Query.prepare((JsonNode)request.filters, query1 -> {
                if (query1 instanceof Query.TermQuery) {
                    Query.TermQuery tq = (Query.TermQuery)query1;
                    tq.setField(GraphInstance.getPropertyField(tq.getField()));
                }
            });
            filterBitset = this.table.query((Query)query, null).finalBitmap;
        } else {
            filterBitset = null;
        }
        if (request.node_property_boost != null && !request.node_property_boost.isEmpty()) {
            boostFields = new HashSet<String>();
            for (String boostField : request.node_property_boost) {
                boostFields.add(GraphInstance.getPropertyField(boostField));
            }
        } else {
            boostFields = null;
        }
        PatriciaTrie nodeScoreMap = new PatriciaTrie();
        try {
            RunnablePool runnablePool = new RunnablePool(this.executorService);
            edge_set = null;
            try {
                facetFields.forEach((arg_0, arg_1) -> this.lambda$request$4(runnablePool, request, filterBitset, result, (Map)nodeScoreMap, boostFields, arg_0, arg_1));
            }
            catch (Throwable throwable) {
                edge_set = throwable;
                throw throwable;
            }
            finally {
                if (runnablePool != null) {
                    if (edge_set != null) {
                        try {
                            runnablePool.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)edge_set)).addSuppressed(throwable);
                        }
                    } else {
                        runnablePool.close();
                    }
                }
            }
        }
        catch (RunnablePoolException e) {
            throw ServerException.of((Throwable)e);
        }
        if (request.exclude_nodes != null) {
            for (String id : request.exclude_nodes) {
                nodeScoreMap.remove(id);
            }
        }
        Object[] nodeScoreArray = nodeScoreMap.values().toArray(new NodeScore[nodeScoreMap.size()]);
        Arrays.sort(nodeScoreArray);
        for (int i = request.getStartOrDefault(); i < request.getRowsOrDefault() && i < nodeScoreArray.length; ++i) {
            resultList.add(new GraphNodeResult().set((NodeScore)nodeScoreArray[i]));
        }
        PatriciaTrie nodeResultMap = new PatriciaTrie();
        for (GraphNodeResult nodeResult : resultList) {
            nodeResultMap.put(nodeResult.node_id, nodeResult);
        }
        Map<String, GraphNode> graphNodeMap = this.getNodes(nodeResultMap.keySet());
        if (graphNodeMap != null) {
            for (GraphNodeResult graphNodeResult : nodeResultMap.values()) {
                GraphNode graphNode = graphNodeMap.get(graphNodeResult.node_id);
                if (graphNode == null) continue;
                graphNodeResult.edges = graphNode.edges;
                graphNodeResult.properties = graphNode.properties;
            }
        }
        return resultList;
    }

    public int getSize() throws IOException {
        return this.table.getSize();
    }

    private /* synthetic */ void lambda$request$4(RunnablePool runnablePool, GraphRequest request, RoaringBitmap filterBitset, QueryResult result, Map nodeScoreMap, Set boostFields, String field, Map facets) {
        runnablePool.submit(() -> {
            Double weight = request.getEdgeWeight(field.substring(FIELD_PREFIX_EDGE.length()));
            for (Map.Entry facet : facets.entrySet()) {
                NodeScore nodeScore;
                Integer docId = null;
                String term = (String)facet.getKey();
                if (filterBitset != null) {
                    docId = result.context.getExistingDocId(term);
                    if (docId == null) continue;
                    RoaringBitmap roaringBitmap = filterBitset;
                    synchronized (roaringBitmap) {
                        if (!filterBitset.contains(docId.intValue())) {
                            continue;
                        }
                    }
                }
                long count = ((CollectorInterface.LongCounter)facet.getValue()).count;
                Map map = nodeScoreMap;
                synchronized (map) {
                    nodeScore = nodeScoreMap.computeIfAbsent(term, t -> new NodeScore(term));
                }
                ScoreBooster scoreInc = new ScoreBooster((double)count * weight);
                if (boostFields != null) {
                    if (docId == null) {
                        docId = result.context.getExistingDocId(term);
                    }
                    if (docId != null) {
                        for (String boostField : boostFields) {
                            result.context.consumeFirstValue(boostField, docId.intValue(), (ValueConsumer)scoreInc);
                        }
                    }
                }
                NodeScore nodeScore2 = nodeScore;
                synchronized (nodeScore2) {
                    nodeScore.score += scoreInc.score;
                }
            }
            return null;
        });
    }

    public static class NodeScore
    implements Comparable<NodeScore> {
        public final String node_id;
        public double score;

        NodeScore(String node_id) {
            this.node_id = node_id;
            this.score = 0.0;
        }

        @Override
        public int compareTo(NodeScore o) {
            return Double.compare(o.score, this.score);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof NodeScore)) {
                return false;
            }
            return this.compareTo((NodeScore)o) == 0;
        }
    }

    private class ScoreBooster
    implements ValueConsumer {
        private double score;

        private ScoreBooster(double score) {
            this.score = score;
        }

        public void consume(double value) {
            this.score *= value;
        }

        public void consume(long value) {
            this.score *= (double)value;
        }

        public void consume(float value) {
            this.score *= (double)value;
        }

        public void consume(String value) {
            throw new RuntimeException("Score cannot be boosted by a string value");
        }
    }
}

