/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.Table;
import com.qwazr.database.store.Tables;
import com.qwazr.graph.GraphInstance;
import com.qwazr.graph.GraphServiceImpl;
import com.qwazr.graph.GraphServiceInterface;
import com.qwazr.graph.model.GraphDefinition;
import com.qwazr.server.ApplicationBuilder;
import com.qwazr.server.GenericServerBuilder;
import com.qwazr.server.ServerException;
import com.qwazr.utils.FileUtils;
import com.qwazr.utils.concurrent.ReadWriteLock;
import com.qwazr.utils.json.DirectoryJsonManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.core.Response;

public class GraphManager
extends DirectoryJsonManager<GraphDefinition> {
    private final ReadWriteLock rwl = ReadWriteLock.stamped();
    private final GraphServiceInterface service;
    private final Map<String, GraphInstance> graphMap;
    private final ExecutorService executorService;

    public GraphManager(ExecutorService executorService, Path graphesDirectory) throws ServerException, IOException {
        super(graphesDirectory.toFile(), GraphDefinition.class);
        this.executorService = executorService;
        this.graphMap = new HashMap<String, GraphInstance>();
        for (String name : this.nameSet()) {
            this.addNewInstance(name, this.get(name));
        }
        this.service = new GraphServiceImpl(this);
    }

    public GraphManager registerContextAttribute(GenericServerBuilder builder) {
        builder.contextAttribute((Object)this);
        return this;
    }

    public GraphManager registerWebService(ApplicationBuilder builder) {
        builder.singletons(new Object[]{this.service});
        return this;
    }

    public static Path checkGraphesDirectory(Path dataDirectory) throws IOException {
        Path tablesDirectory = dataDirectory.resolve("graph");
        if (!Files.exists(tablesDirectory, new LinkOption[0])) {
            Files.createDirectory(tablesDirectory, new FileAttribute[0]);
        }
        return tablesDirectory;
    }

    public GraphServiceInterface getService() {
        return this.service;
    }

    private GraphInstance addNewInstance(String graphName, GraphDefinition graphDef) throws IOException, ServerException {
        File dbDirectory = new File(this.directory, graphName);
        if (!dbDirectory.exists()) {
            dbDirectory.mkdir();
        }
        Table table = Tables.getInstance((File)dbDirectory, (KeyStore.Impl)graphDef.implementation);
        GraphInstance graphInstance = new GraphInstance(this.executorService, table, graphDef);
        graphInstance.checkFields();
        this.graphMap.put(graphName, graphInstance);
        return graphInstance;
    }

    public GraphInstance getGraphInstance(String graphName) throws ServerException {
        return (GraphInstance)this.rwl.readEx(() -> {
            GraphInstance graphInstance = this.graphMap.get(graphName);
            if (graphInstance == null) {
                throw new ServerException(Response.Status.NOT_FOUND, "Graph instance not found");
            }
            return graphInstance;
        });
    }

    public Set<String> nameSet() {
        return super.nameSet();
    }

    public GraphDefinition get(String name) throws IOException {
        return (GraphDefinition)super.get(name);
    }

    public void createUpdateGraph(String graphName, GraphDefinition graphDef) throws IOException, ServerException {
        this.rwl.writeEx(() -> {
            super.set(graphName, (Object)graphDef);
            this.graphMap.remove(graphName);
            this.addNewInstance(graphName, graphDef);
        });
    }

    public GraphDefinition delete(String graphName) throws ServerException, IOException {
        return (GraphDefinition)this.rwl.writeEx(() -> {
            GraphDefinition graphDef = (GraphDefinition)super.delete(graphName);
            File dbDirectory = new File(this.directory, graphName);
            Tables.delete((File)dbDirectory);
            FileUtils.deleteDirectory((File)dbDirectory);
            this.graphMap.remove(graphName);
            return graphDef;
        });
    }
}

