/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.qwazr.graph.GraphServiceInterface;
import com.qwazr.graph.GraphSingleClient;
import com.qwazr.graph.model.GraphDefinition;
import com.qwazr.graph.model.GraphNode;
import com.qwazr.graph.model.GraphNodeResult;
import com.qwazr.graph.model.GraphRequest;
import com.qwazr.graph.model.GraphResult;
import com.qwazr.server.RemoteService;
import com.qwazr.server.ServerException;
import com.qwazr.server.client.MultiClient;
import com.qwazr.server.client.MultiWebApplicationException;
import com.qwazr.utils.LoggerUtils;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;

public class GraphMultiClient
extends MultiClient<GraphSingleClient>
implements GraphServiceInterface {
    private static final Logger logger = LoggerUtils.getLogger(GraphMultiClient.class);

    GraphMultiClient(ExecutorService executor, RemoteService ... remote) throws URISyntaxException {
        super((Object[])GraphMultiClient.getClients(remote), executor);
    }

    private static GraphSingleClient[] getClients(RemoteService ... remotes) {
        GraphSingleClient[] clients = new GraphSingleClient[remotes.length];
        int i = 0;
        for (RemoteService remote : remotes) {
            clients[i++] = new GraphSingleClient(remote);
        }
        return clients;
    }

    @Override
    public Set<String> list() {
        List results = this.forEachParallel(GraphSingleClient::list, logger);
        if (results == null || results.isEmpty()) {
            Collections.emptySet();
        }
        TreeSet<String> globalSet = new TreeSet<String>();
        results.forEach(globalSet::addAll);
        return globalSet;
    }

    @Override
    public GraphDefinition createUpdateGraph(String graphName, GraphDefinition graphDef) {
        List results = this.forEachParallel(c -> c.createUpdateGraph(graphName, graphDef), logger);
        if (results == null || results.isEmpty()) {
            throw new InternalServerErrorException();
        }
        return (GraphDefinition)results.get(0);
    }

    @Override
    public GraphResult getGraph(String graphName) {
        MultiWebApplicationException.Builder exceptions = MultiWebApplicationException.of((Logger)logger);
        GraphResult result = (GraphResult)this.firstRandomSuccess(c -> c.getGraph(graphName), arg_0 -> ((MultiWebApplicationException.Builder)exceptions).add(arg_0));
        if (result != null) {
            return result;
        }
        throw exceptions.isEmpty() ? new NotFoundException("Graph not found: " + graphName) : exceptions.build();
    }

    @Override
    public GraphDefinition deleteGraph(String graphName) {
        try {
            MultiWebApplicationException.Builder exceptions = MultiWebApplicationException.of((Logger)logger);
            List results = this.forEachParallel(c -> this.deleteGraph(graphName), arg_0 -> ((MultiWebApplicationException.Builder)exceptions).add(arg_0));
            if (results == null || !results.isEmpty()) {
                return (GraphDefinition)results.get(0);
            }
            throw exceptions.isEmpty() ? new NotFoundException("Graph not found: " + graphName) : exceptions.build();
        }
        catch (Exception e) {
            throw ServerException.getJsonException((Logger)logger, (Exception)e);
        }
    }

    @Override
    public Set<String> createUpdateNodes(String db_name, LinkedHashMap<String, GraphNode> nodes, Boolean upsert) {
        return null;
    }

    @Override
    public Long createUpdateNodes(String db_name, Boolean upsert, InputStream inpustStream) {
        return null;
    }

    @Override
    public GraphNode createUpdateNode(String db_name, String node_id, GraphNode node, Boolean upsert) {
        return null;
    }

    @Override
    public GraphNode getNode(String db_name, String node_id) {
        return null;
    }

    @Override
    public GraphNode deleteNode(String db_name, String node_id) {
        return null;
    }

    @Override
    public GraphNode createEdge(String db_name, String node_id, String edge_type, String to_node_id) {
        return null;
    }

    @Override
    public GraphNode deleteEdge(String db_name, String node_id, String edge_type, String to_node_id) {
        return null;
    }

    @Override
    public List<GraphNodeResult> requestNodes(String db_name, GraphRequest request) {
        return null;
    }
}

