/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.qwazr.cluster.ClusterManager;
import com.qwazr.graph.GraphManager;
import com.qwazr.graph.GraphServiceInterface;
import com.qwazr.server.ApplicationBuilder;
import com.qwazr.server.BaseServer;
import com.qwazr.server.GenericServer;
import com.qwazr.server.GenericServerBuilder;
import com.qwazr.server.RestApplication;
import com.qwazr.server.WelcomeShutdownService;
import com.qwazr.server.configuration.ServerConfiguration;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GraphServer
implements BaseServer {
    private final GenericServer server;
    private final GraphManager graphManager;
    private static volatile GraphServer INSTANCE;

    private GraphServer(ServerConfiguration configuration) throws IOException, URISyntaxException {
        ExecutorService executorService = Executors.newCachedThreadPool();
        GenericServerBuilder builder = GenericServer.of((ServerConfiguration)configuration, (ExecutorService)executorService);
        HashSet<String> services = new HashSet<String>();
        services.add("cluster");
        services.add("graph");
        ApplicationBuilder webServices = ApplicationBuilder.of((String[])new String[]{"/*"}).classes(RestApplication.JSON_CLASSES).singletons(new Object[]{new WelcomeShutdownService()});
        new ClusterManager(executorService, configuration).registerProtocolListener(builder, services).registerContextAttribute(builder).registerWebService(webServices);
        this.graphManager = new GraphManager(executorService, GraphManager.checkGraphesDirectory(configuration.dataDirectory.toPath())).registerContextAttribute(builder).registerWebService(webServices);
        builder.getWebServiceContext().jaxrs(webServices);
        this.server = builder.build();
    }

    public GenericServer getServer() {
        return this.server;
    }

    public GraphServiceInterface getService() {
        return this.graphManager.getService();
    }

    public static GraphServer getInstance() {
        return INSTANCE;
    }

    public static synchronized void main(String ... args) throws Exception {
        GraphServer.shutdown();
        INSTANCE = new GraphServer(new ServerConfiguration(args));
        INSTANCE.start();
    }

    public static synchronized void shutdown() {
        if (INSTANCE == null) {
            return;
        }
        INSTANCE.stop();
        INSTANCE = null;
    }
}

