/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.fasterxml.jackson.core.type.TypeReference;
import com.qwazr.graph.GraphInstance;
import com.qwazr.graph.GraphManager;
import com.qwazr.graph.GraphServiceInterface;
import com.qwazr.graph.model.GraphDefinition;
import com.qwazr.graph.model.GraphNode;
import com.qwazr.graph.model.GraphNodeResult;
import com.qwazr.graph.model.GraphRequest;
import com.qwazr.graph.model.GraphResult;
import com.qwazr.server.AbstractServiceImpl;
import com.qwazr.server.ServerException;
import com.qwazr.utils.LoggerUtils;
import com.qwazr.utils.ObjectMappers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

class GraphServiceImpl
extends AbstractServiceImpl
implements GraphServiceInterface {
    private static final Logger LOGGER = LoggerUtils.getLogger(GraphServiceImpl.class);
    private volatile GraphManager graphManager;
    public static final TypeReference<Map<String, GraphNode>> MapStringGraphNodeTypeRef = new TypeReference<Map<String, GraphNode>>(){};

    GraphServiceImpl(GraphManager graphManager) {
        this.graphManager = graphManager;
    }

    public GraphServiceImpl() {
    }

    @PostConstruct
    public void init() {
        this.graphManager = (GraphManager)((Object)this.getContextAttribute(GraphManager.class));
    }

    @Override
    public Set<String> list() {
        return this.graphManager.nameSet();
    }

    @Override
    public GraphDefinition createUpdateGraph(String graphName, GraphDefinition graphDef) {
        try {
            this.graphManager.createUpdateGraph(graphName, graphDef);
            return graphDef;
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }

    private GraphDefinition getGraphOrNotFound(String graphName) throws ServerException, IOException {
        GraphDefinition graphDef = this.graphManager.get(graphName);
        if (graphDef == null) {
            throw new ServerException(Response.Status.NOT_FOUND, "Graph not found: " + graphName);
        }
        return graphDef;
    }

    @Override
    public GraphResult getGraph(String graphName) {
        try {
            GraphDefinition graphDef = this.getGraphOrNotFound(graphName);
            GraphInstance graphInstance = this.graphManager.getGraphInstance(graphName);
            return new GraphResult(graphDef, graphInstance.getSize());
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }

    private GraphDefinition deleteGraphLocal(String graphName) throws IOException, URISyntaxException, ServerException {
        GraphDefinition base = this.getGraphOrNotFound(graphName);
        this.graphManager.delete(graphName);
        return base;
    }

    @Override
    public GraphDefinition deleteGraph(String graphName) {
        try {
            return this.deleteGraphLocal(graphName);
        }
        catch (ServerException | IOException | URISyntaxException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }

    @Override
    public GraphNode createUpdateNode(String graphName, String node_id, GraphNode node, Boolean upsert) {
        try {
            this.graphManager.getGraphInstance(graphName).createUpdateNode(node_id, node, upsert);
            return node;
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }

    @Override
    public Set<String> createUpdateNodes(String graphName, LinkedHashMap<String, GraphNode> nodes, Boolean upsert) {
        try {
            this.graphManager.getGraphInstance(graphName).createUpdateNodes(nodes, upsert);
            return nodes.keySet();
        }
        catch (ServerException | IOException | URISyntaxException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long createUpdateNodes(String graphName, Boolean upsert, InputStream inputStream) {
        Long l;
        InputStreamReader irs;
        block9: {
            GraphInstance graphInstance = this.graphManager.getGraphInstance(graphName);
            irs = null;
            BufferedReader br = null;
            try {
                String line;
                irs = new InputStreamReader(inputStream, "UTF-8");
                br = new BufferedReader(irs);
                long count = 0L;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    Map nodeMap = (Map)ObjectMappers.JSON.readValue(line, MapStringGraphNodeTypeRef);
                    graphInstance.createUpdateNodes(nodeMap, upsert);
                    count += (long)nodeMap.size();
                }
                l = count;
                if (br == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        IOUtils.closeQuietly(br);
                    }
                    if (irs != null) {
                        IOUtils.closeQuietly((Reader)irs);
                    }
                    throw throwable;
                }
                catch (ServerException | IOException | URISyntaxException e) {
                    throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
                }
            }
            IOUtils.closeQuietly((Reader)br);
        }
        if (irs != null) {
            IOUtils.closeQuietly((Reader)irs);
        }
        return l;
    }

    private GraphNode getNodeOrNotFound(GraphInstance graphInstance, String node_id) throws IOException, URISyntaxException {
        GraphNode node = graphInstance.getNode(node_id);
        if (node != null) {
            return node;
        }
        throw new ServerException(Response.Status.NOT_FOUND, "Graph node not found: " + node_id);
    }

    @Override
    public GraphNode getNode(String graphName, String node_id) {
        try {
            GraphInstance graphInstance = this.graphManager.getGraphInstance(graphName);
            return this.getNodeOrNotFound(graphInstance, node_id);
        }
        catch (ServerException | IOException | URISyntaxException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }

    @Override
    public GraphNode deleteNode(String graphName, String node_id) {
        try {
            GraphInstance graphInstance = this.graphManager.getGraphInstance(graphName);
            GraphNode node = this.getNodeOrNotFound(graphInstance, node_id);
            graphInstance.deleteNode(node_id);
            return node;
        }
        catch (ServerException | IOException | URISyntaxException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }

    @Override
    public GraphNode createEdge(String graphName, String node_id, String edge_type, String to_node_id) {
        try {
            GraphInstance graphInstance = this.graphManager.getGraphInstance(graphName);
            return graphInstance.createEdge(node_id, edge_type, to_node_id);
        }
        catch (ServerException | IOException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }

    @Override
    public GraphNode deleteEdge(String graphName, String node_id, String edge_type, String to_node_id) {
        try {
            GraphInstance graphInstance = this.graphManager.getGraphInstance(graphName);
            return graphInstance.deleteEdge(node_id, edge_type, to_node_id);
        }
        catch (ServerException | IOException | URISyntaxException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }

    @Override
    public List<GraphNodeResult> requestNodes(String graphName, GraphRequest request) {
        try {
            GraphInstance graphInstance = this.graphManager.getGraphInstance(graphName);
            return graphInstance.request(request);
        }
        catch (ServerException | IOException | URISyntaxException e) {
            throw ServerException.getJsonException((Logger)LOGGER, (Exception)e);
        }
    }
}

