/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.qwazr.graph.model.GraphDefinition;
import com.qwazr.graph.model.GraphNode;
import com.qwazr.graph.model.GraphNodeResult;
import com.qwazr.graph.model.GraphRequest;
import com.qwazr.graph.model.GraphResult;
import com.qwazr.server.ServiceInterface;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericType;

@RolesAllowed(value={"graph"})
@Path(value="/graph")
public interface GraphServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "graph";
    public static final GenericType<TreeSet<String>> setStringType = new GenericType<TreeSet<String>>(){};

    @GET
    @Path(value="/")
    @Produces(value={"application/json; charset=UTF-8"})
    public Set<String> list();

    @POST
    @Path(value="/{graph_name}")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public GraphDefinition createUpdateGraph(@PathParam(value="graph_name") String var1, GraphDefinition var2);

    @GET
    @Path(value="/{graph_name}")
    @Produces(value={"application/json; charset=UTF-8"})
    public GraphResult getGraph(@PathParam(value="graph_name") String var1);

    @DELETE
    @Path(value="/{graph_name}")
    @Produces(value={"application/json; charset=UTF-8"})
    public GraphDefinition deleteGraph(@PathParam(value="graph_name") String var1);

    @POST
    @Path(value="/{graph_name}/node")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Set<String> createUpdateNodes(@PathParam(value="graph_name") String var1, LinkedHashMap<String, GraphNode> var2, @QueryParam(value="upsert") Boolean var3);

    @POST
    @Path(value="/{graph_name}/node")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Long createUpdateNodes(@PathParam(value="graph_name") String var1, @QueryParam(value="upsert") Boolean var2, InputStream var3);

    @POST
    @Path(value="/{graph_name}/node/{node_id}")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public GraphNode createUpdateNode(@PathParam(value="graph_name") String var1, @PathParam(value="node_id") String var2, GraphNode var3, @QueryParam(value="upsert") Boolean var4);

    @GET
    @Path(value="/{graph_name}/node/{node_id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public GraphNode getNode(@PathParam(value="graph_name") String var1, @PathParam(value="node_id") String var2);

    @DELETE
    @Path(value="/{graph_name}/node/{node_id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public GraphNode deleteNode(@PathParam(value="graph_name") String var1, @PathParam(value="node_id") String var2);

    @POST
    @Path(value="/{graph_name}/node/{node_id}/edge/{edge_type}/{to_node_id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public GraphNode createEdge(@PathParam(value="graph_name") String var1, @PathParam(value="node_id") String var2, @PathParam(value="edge_type") String var3, @PathParam(value="to_node_id") String var4);

    @DELETE
    @Path(value="/{graph_name}/node/{node_id}/edge/{edge_type}/{to_node_id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public GraphNode deleteEdge(@PathParam(value="graph_name") String var1, @PathParam(value="node_id") String var2, @PathParam(value="edge_type") String var3, @PathParam(value="to_node_id") String var4);

    @POST
    @Path(value="/{graph_name}/request")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public List<GraphNodeResult> requestNodes(@PathParam(value="graph_name") String var1, GraphRequest var2);
}

