/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.qwazr.graph.GraphServiceInterface;
import com.qwazr.graph.model.GraphDefinition;
import com.qwazr.graph.model.GraphNode;
import com.qwazr.graph.model.GraphNodeResult;
import com.qwazr.graph.model.GraphRequest;
import com.qwazr.graph.model.GraphResult;
import com.qwazr.server.RemoteService;
import com.qwazr.server.client.JsonClient;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;

public class GraphSingleClient
extends JsonClient
implements GraphServiceInterface {
    private final WebTarget graphTarget;

    GraphSingleClient(RemoteService remote) {
        super(remote);
        this.graphTarget = this.client.target(remote.serviceAddress).path("graph");
    }

    @Override
    public Set<String> list() {
        return (Set)this.graphTarget.request(new String[]{"application/json"}).get(setStringType);
    }

    @Override
    public GraphResult createUpdateGraph(String graphName, GraphDefinition graphDef) {
        return (GraphResult)this.graphTarget.path(graphName).request(new String[]{"application/json"}).post(Entity.json((Object)graphDef), GraphResult.class);
    }

    @Override
    public GraphResult getGraph(String graphName) {
        return (GraphResult)this.graphTarget.path(graphName).request(new String[]{"application/json"}).get(GraphResult.class);
    }

    @Override
    public GraphResult deleteGraph(String graphName) {
        return (GraphResult)this.graphTarget.path(graphName).request(new String[]{"application/json"}).delete(GraphResult.class);
    }

    @Override
    public Set<String> createUpdateNodes(String db_name, LinkedHashMap<String, GraphNode> nodes, Boolean upsert) {
        return null;
    }

    @Override
    public Long createUpdateNodes(String db_name, Boolean upsert, InputStream inpustStream) {
        return null;
    }

    @Override
    public GraphNode createUpdateNode(String db_name, String node_id, GraphNode node, Boolean upsert) {
        return null;
    }

    @Override
    public GraphNode getNode(String db_name, String node_id) {
        return null;
    }

    @Override
    public GraphNode deleteNode(String db_name, String node_id) {
        return null;
    }

    @Override
    public GraphNode createEdge(String db_name, String node_id, String edge_type, String to_node_id) {
        return null;
    }

    @Override
    public GraphNode deleteEdge(String db_name, String node_id, String edge_type, String to_node_id) {
        return null;
    }

    @Override
    public List<GraphNodeResult> requestNodes(String db_name, GraphRequest request) {
        return null;
    }
}

